package com.biz.crm.cps.business.agreement.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 分利协议模板 的 mybatis 操作接口
 * @author jerry7
 * @date 2021-07-23
 */
public interface ProfitAgreementTemplateMapper extends BaseMapper<ProfitAgreementTemplate> {

  /**
   * 根据主键查询分利模板详细信息（包括关联表）
   * @param id 主键id
   * @return 分利模板实体信息
   */
  ProfitAgreementTemplate findDetailsById(@Param("id") String id);

  /**
   * 分页查询
   * queryFlag=H5时接口说明，此方法的查询条件：组织编码、渠道、标签特殊条件处理如下
   *        and
   *        case when org.org_code is not null
   *        then org.org_code = #{dto.orgCode}
   *        else 1=1 end
   *        and
   *        case when channel.channel_code is not null
   *        then channel.channel_code = #{dto.channelCode}
   *        else 1=1 end
   * @param page 分页参数
   * @param dto dto
   * @return 返回列表
   */
  Page<ProfitAgreementTemplate> findByConditions(Page<ProfitAgreementTemplate> page, @Param("dto") ProfitAgreementTemplatePaginationDto dto);

  /**
   * 条件查询协议模板
   * @param dto dto
   * @return 返回列表
   */
  List<ProfitAgreementTemplate> findByConditions( @Param("dto") ProfitAgreementTemplatePaginationDto dto);

}
