package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.AgreementLadder;
import com.biz.crm.cps.business.agreement.local.mapper.AgreementLadderMapper;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementLadderDto;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 用于协议阶梯相关的sql操作
 *
 * @author jerry7
 */
@Component
public class AgreementLadderRepository extends ServiceImpl<AgreementLadderMapper, AgreementLadder> {

  @Autowired
  private AgreementLadderMapper agreementLadderMapper;

  /**
   * 分页查询条件组装,并查询数据
   *
   * @param dto 查询条件
   */
  public Page<AgreementLadder> findByConditions(Pageable pageable, AgreementLadderDto dto) {
    Page<AgreementLadder> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return agreementLadderMapper.findByConditions(page, dto);
  }

  /**
   * 根据阶梯编码查询协议阶梯信息
   *
   * @param ladderCode 阶梯编码
   */
  public AgreementLadder findByLadderCode(String ladderCode) {
    return this.query().getBaseMapper().selectOne(new QueryWrapper<AgreementLadder>().eq("ladder_code", ladderCode));
  }

  /**
   * 批量启用-禁用
   *
   * @param enable 启用或禁用
   * @param ids    操作主键集合
   */
  public void updateEnableStatusByIds(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    UpdateWrapper<AgreementLadder> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("enable_status", enable.getCode());
    updateWrapper.in("id", ids);
    this.update(updateWrapper);
  }
}
