package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.mapper.AgreementMapper;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;

import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 用于协议相关的sql操作
 * @author songjingen
 */
@Component
public class AgreementRepository  extends ServiceImpl<AgreementMapper, Agreement> {

  @Resource
  private AgreementMapper agreementMapper;
  /**
   * 分页查询条件组装,并查询数据
   * @param dto
   * @return
   */
  public Page<Agreement> findByConditions(Pageable pageable, AgreementDto dto) {
    Page<Agreement> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<Agreement> agreementPage = agreementMapper.findByConditions(page, dto);
    return agreementPage;
  }

  /**
   * 查询数据不带分页
   * @param dto
   * @return
   */
  public List<Agreement> findByConditions(AgreementDto dto) {
    List<Agreement> agreementPage = agreementMapper.findByConditions(dto);
    return agreementPage;
  }

  /**
   * 签署，根据id修改签署状态（可批量）
   * @param ids
   */
  public void updateSignStatusByIds(SignStatusEnum signStatusEnum, List<String> ids) {
    UpdateWrapper<Agreement> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("sign_status", signStatusEnum.getCode());
    updateWrapper.in("id", ids);
    this.update(updateWrapper);
  }

  /**
   * 终止，根据id修改协议状态（可批量）
   * @param ids
   */
  public void updateAgreementStatusByIds(AgreementStatusEnum agreementStatusEnum, List<String> ids) {
    UpdateWrapper<Agreement> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("agreement_status", agreementStatusEnum.getCode());
    updateWrapper.in("id", ids);
    this.update(updateWrapper);
  }

  /**
   * 查看详情，包含签署情况
   * @param id
   * @return
   */
  public Agreement findDetailsById(String id) {
    return agreementMapper.findDetailsById(id);
  }

  /**
   * 根据协议编码更改经销商的签署状态
   * @param agreementCode
   */
  public void updateDealerSignStatusById(SignStatusEnum signStatusEnum, String agreementCode) {
    UpdateWrapper<Agreement> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("dealer_sign_status", signStatusEnum.getCode());
    updateWrapper.eq("agreement_code", agreementCode);
    this.update(updateWrapper);
  }

  /**
   * 根据id批量查询数据
   * @param ids
   */
  public List<Agreement> findByIds(List<String> ids) {
    QueryWrapper<Agreement> queryWrapper = new QueryWrapper<>();
    queryWrapper.in("id", ids);
    return this.list(queryWrapper);
  }

  /**
   * 根据登录信息查询出协议实例集合
   * @param dto
   * @return
   */
  public List<Agreement> findByConditions(LoginUserAgreementDto dto) {
    List<Agreement> agreements = this.agreementMapper.findByLoginUserAgreementDto(dto);
    return agreements;
  }

  /**
   * 查询终端已签署的协议信息
   * @param terminalCode
   * @return
   */
  public List<Agreement> findByTerminalCode(String terminalCode) {
    QueryWrapper<Agreement> queryWrapper = new QueryWrapper<>();
    queryWrapper.eq("terminal_code", terminalCode);
    return this.list(queryWrapper);
  }

  /**
   * 根据协议编码查询信息
   * @param agreementCode
   * @return
   */
  public Agreement findByAgreementCode(String agreementCode) {
    QueryWrapper<Agreement> queryWrapper = new QueryWrapper<>();
    queryWrapper.eq("agreement_code", agreementCode);
    return this.getOne(queryWrapper);
  }

  /**
   * 查询协议协议生效开始时间小于等于当前时间，且协议状态未开始；
   * 查询协议协议生效结束时间小于当前时间，且协议状态进行中
   * @param date
   * @return
   */
  public List<Agreement> findByCurrentTime(Date date) {
    return this.agreementMapper.findByCurrentTime(date);
  }

  /**
   * 根据templateCode终止（单个或者批量）
   * @param templateCodes
   * @return
   */
  public List<Agreement> findByTemplateCodes(List<String> templateCodes) {
    QueryWrapper<Agreement> queryWrapper = new QueryWrapper<>();
    queryWrapper.in("template_code", templateCodes);
    return this.list(queryWrapper);
  }
}
