package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplateDetailLog;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplateLog;
import com.biz.crm.cps.business.agreement.local.mapper.ProfitAgreementTemplateDetailLogMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 模板日志明细持久化
 * @Author: zengxingwang
 * @Date: 2021/11/19 13:50
 */
@Component
public class ProfitAgreementTemplateDetailLogRepository extends ServiceImpl<ProfitAgreementTemplateDetailLogMapper, ProfitAgreementTemplateDetailLog> {

  @Autowired
  private ProfitAgreementTemplateDetailLogMapper profitAgreementTemplateDetailLogMapper;

  /**
   * 日志明细查询
   * @param pageable
   * @param logId
   * @return
   */
  public Page<ProfitAgreementTemplateDetailLog> findByLogId(Pageable pageable, String logId) {
    Page<ProfitAgreementTemplateLog> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return profitAgreementTemplateDetailLogMapper.findByLogId(page, logId);
  }
}
