package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplateLog;
import com.biz.crm.cps.business.agreement.local.mapper.ProfitAgreementTemplateLogMapper;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplateLogDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 模板日志持久化
 * @Author: zengxingwang
 * @Date: 2021/11/19 13:46
 */
@Component
public class ProfitAgreementTemplateLogRepository extends ServiceImpl<ProfitAgreementTemplateLogMapper, ProfitAgreementTemplateLog> {

  @Autowired
  private ProfitAgreementTemplateLogMapper profitAgreementTemplateLogMapper;

  /**
   * 日志分页条件查询
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ProfitAgreementTemplateLog> findByConditions(Pageable pageable, ProfitAgreementTemplateLogDto dto) {
    Page<ProfitAgreementTemplateLog> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return profitAgreementTemplateLogMapper.findByConditions(page, dto);
  }
}
