package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.TemplateChannelRelationship;
import com.biz.crm.cps.business.agreement.local.mapper.TemplateChannelRelationshipMapper;

import org.springframework.stereotype.Component;

/**
 * 分利协议模板关联渠道数据处理
 * @author jerry7
 * @date 2021-07-26
 */
@Component
public class TemplateChannelRelationshipRepository extends ServiceImpl<TemplateChannelRelationshipMapper, TemplateChannelRelationship> {

  /**
   * 根据模板编码删除关联信息
   * @param templateCode
   */
  public void deleteByTemplateCode(String templateCode) {
    this.lambdaUpdate().eq(TemplateChannelRelationship::getTemplateCode, templateCode).remove();
  }
}
