package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.TemplateOrgRelationship;
import com.biz.crm.cps.business.agreement.local.mapper.TemplateOrgRelationshipMapper;

import org.springframework.stereotype.Component;

/**
 * 分利协议模板关联组织数据处理
 *
 * @author jerry7
 * @date 2021-07-23
 */
@Component
public class TemplateOrgRelationshipRepository extends ServiceImpl<TemplateOrgRelationshipMapper, TemplateOrgRelationship> {

  /**
   * 通过模板编码删除关联组织数据
   * @param templateCode
   */
  public void deleteByTemplateCode(String templateCode) {
    this.lambdaUpdate().eq(TemplateOrgRelationship::getTemplateCode, templateCode).remove();
  }
}
