package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.TemplatePolicyRelationship;
import com.biz.crm.cps.business.agreement.local.mapper.TemplatePolicyRelationshipMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 分利协议模板关联政策数据处理
 * @author jerry7
 * @date 2021-07-23
 */
@Component
public class TemplatePolicyRelationshipRepository extends ServiceImpl<TemplatePolicyRelationshipMapper, TemplatePolicyRelationship> {


  /**
   * 通过模板编码删除关联数据
   * @param templateCode
   */
  public void deleteByTemplateCode(String templateCode) {
    this.lambdaUpdate().eq(TemplatePolicyRelationship::getTemplateCode, templateCode).remove();
  }

  /**
   * 查询包量任务
   * @param templateCodes
   * @return
   */
  public List<TemplatePolicyRelationship> findByPolicyCodeAndTemplateCodes(String policyCode, List<String> templateCodes) {
    QueryWrapper<TemplatePolicyRelationship> wrapper = new QueryWrapper();
    wrapper.eq("policy_code", policyCode);
    wrapper.in("template_code", templateCodes);
    return this.list(wrapper);
  }

  /**
   * 根据模板编码查询信息
   * @param templateCode
   * @return
   */
  public List<TemplatePolicyRelationship> findByTemplateCode(String templateCode) {
    return this.lambdaQuery().eq(TemplatePolicyRelationship::getTemplateCode, templateCode).list();
  }
}
