package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.TemplateTag;
import com.biz.crm.cps.business.agreement.local.mapper.TemplateTagMapper;
import org.springframework.stereotype.Component;

/**
 * 分利协议模板关联标签数据处理
 * @author jerry7
 * @date 2021-07-23
 */
@Component
public class TemplateTagRepository extends ServiceImpl<TemplateTagMapper, TemplateTag> {

  /**
   * 根据模板编码删除关联信息
   * @param templateCode
   */
  public void deleteByTemplateCode(String templateCode) {
    this.lambdaUpdate().eq(TemplateTag::getTemplateCode, templateCode).remove();
  }
}
