package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.TemplateTerminalRelationship;
import com.biz.crm.cps.business.agreement.local.mapper.TemplateTerminalRelationshipMapper;
import org.springframework.stereotype.Component;

/**
 * @Author: zengxingwang
 * @Date: 2021/11/19 10:10
 */
@Component
public class TemplateTerminalRelationshipRepository extends ServiceImpl<TemplateTerminalRelationshipMapper, TemplateTerminalRelationship> {

  /**
   * 根据模板编码删除关联信息
   * @param templateCode
   */
  public void deleteByTemplateCode(String templateCode) {
    this.lambdaUpdate().eq(TemplateTerminalRelationship::getTemplateCode, templateCode).remove();
  }
}
