package com.biz.crm.cps.business.agreement.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.AgreementLadder;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementLadderDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 协议阶梯接口
 * @author jerry7
 */
public interface AgreementLadderService {

  /**
   * 协议阶梯新增
   * @param agreementLadder 协议阶梯实体
   * @return 新增结果
   */
  AgreementLadder create(AgreementLadder agreementLadder);

  /**
   * 分页条件查询阶梯协议
   * @param pageable 分页信息
   * @param dto 查询条件
   * @return 阶梯协议列表
   */
  Page<AgreementLadder> findByConditions(Pageable pageable, AgreementLadderDto dto);

  /**
   * 批量启用
   * @param ids 主键列表
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用
   * @param ids 主键列表
   */
  void disableBatch(List<String> ids);

  /**
   * 根据阶梯编码查询协议阶梯实体
   * @param ladderCode 阶梯编码
   * @return 协议阶梯实体
   */
  AgreementLadder findByLadderCode(String ladderCode);
}
