package com.biz.crm.cps.business.agreement.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignDto;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * 分利协议相关业务处理接口
 * @author songjingen
 */
public interface AgreementService {

  /**
   * 根据id签署（单个或者批量）
   * @param ids
   */
  void enable(List<String> ids);

  /**
   * 根据id终止（单个或者批量）
   * @param ids
   */
  void disable(List<String> ids);

  /**
   * 根据id终止（单个或者批量）
   * @param templateCodes
   */
  void disableByTemplateCodes(List<String> templateCodes);

  /**
   * 协议新增（终端协议签署）
   * @param dto
   * @return
   */
  void create(AgreementSignDto dto);

  /**
   * 获取协议信息的详情
   * @param id
   * @return
   */
  Agreement findById(String id);

  /**
   * 查询分利协议基本信息详情包含签署情况
   * @param id
   * @return
   */
  Agreement findDetailsById(String id);

  /**
   * 分页查询数据
   * @param pageable
   * @param dto
   * @return
   */
  Page<Agreement> findByConditions(Pageable pageable, AgreementDto dto);

  /**
   * 查询协议协议生效开始时间小于等于当前时间，且协议状态未开始；
   * 查询协议协议生效结束时间小于当前时间，且协议状态进行中
   * @param date
   * @return
   */
  List<Agreement> findByCurrentTime(Date date);

  /**
   * 批量新增
   * @param list
   */
  void createOrUpdateBatch(List<Agreement> list);

  /**
   * 根据templateCodes集合查询数据集合
   * @param templateCodes
   * @return
   */
  List<Agreement> findByTemplateCodes(List<String> templateCodes);

  /**
   * 根据id撤销终止（单个或者批量）
   * @param ids
   */
  void revoke(List<String> ids);
}
