package com.biz.crm.cps.business.agreement.local.service;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;

import java.util.List;
import java.util.Set;

/**
 * @author jerry7
 * @date 2021-07-21
 * 分利协议模板service
 */
public interface ProfitAgreementTemplateService {

  /**
   * 创建协议模板
   * @param agreementTemplate 协议模板实体
   * @return 创建后协议模板信息
   */
  ProfitAgreementTemplate create(ProfitAgreementTemplate agreementTemplate);

  /**
   * 由satrun骨架创建协议实体模型对象，用于前端表单数据暂存
   * @param agreementTemplate 协议模型实体
   * @return 创建完成后协议模板信息
   */
  ProfitAgreementTemplate createForm(ProfitAgreementTemplate agreementTemplate);

  /**
   * 根据id查询协议模板数据(不包括关联信息)
   * @param id 协议模板id
   * @return 协议模板实体
   */
  ProfitAgreementTemplate findById(String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * @return 协议模板实体
   */
  ProfitAgreementTemplate findDetailsById(String id);

  /**
   * 批量启用
   * @param ids 主键列表
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用
   * @param ids 主键列表
   */
  void disableBatch(List<String> ids);

  /**
   * 数据在request的body里
   * @param jsonObject
   * @return
   */
  ProfitAgreementTemplate create(JSONObject jsonObject);

  /**
   * 数据在request的body里
   * 编写（更改）协议模板
   * @param jsonObject
   */
  ProfitAgreementTemplate update(JSONObject jsonObject);

  /**
   * 根据模板编码获取分利协议模板信息
   *
   * @param templateCodeSet
   * @return
   */
  List<ProfitAgreementTemplate> findByTemplateCodes(Set<String> templateCodeSet);
}
