package com.biz.crm.cps.business.agreement.local.service.dynamictask;

import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.bizunited.nebula.task.annotations.DynamicTaskService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 协议动态任务
 * @author songjingen
 */
@Component
public class AgreementDynamicTask {

  @Autowired
  private AgreementService agreementService;

  /**
   * 每日更新协议状态
   */
  @Transactional
  @DynamicTaskService(cornExpression = "1 0 0 * * ?", taskDesc = "每日更新协议状态")
  public void updateAgreementStatus(){
    List<Agreement> list = this.agreementService.findByCurrentTime(new Date());
    if (CollectionUtils.isEmpty(list)){
      return;
    }
    list.stream().forEach(agreement -> {
      if (AgreementStatusEnum.NOT_STARTED.getCode().equals(agreement.getAgreementStatus())) {
        agreement.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
      }
      if (AgreementStatusEnum.EXECUTING.getCode().equals(agreement.getAgreementStatus())) {
        agreement.setAgreementStatus(AgreementStatusEnum.COMPLETED.getCode());
      }
    });
    this.agreementService.createOrUpdateBatch(list);
  }
}
