package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.local.entity.AgreementLadder;
import com.biz.crm.cps.business.agreement.local.repository.AgreementLadderRepository;
import com.biz.crm.cps.business.agreement.local.service.AgreementLadderService;
import com.biz.crm.cps.business.agreement.sdk.common.constant.AgreementCodeConstant;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementLadderTypeEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementLadderDto;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 分利协议相关业务处理实现
 *
 * @author songjingen
 */
@Service
public class AgreementLadderServiceImpl implements AgreementLadderService {

  @Autowired
  private GenerateCodeService generateCodeService;

  @Autowired
  private LoginUserService loginUserService;

  @Autowired
  private AgreementLadderRepository agreementLadderRepository;


  @Override
  @Transactional
  public AgreementLadder create(AgreementLadder agreementLadder) {
    validateAgreementLadder(agreementLadder);
    //生成协议编码
    agreementLadder.setLadderCode(generateCodeService.generateCode(AgreementCodeConstant.AGREEMENT_LADDER_CODE, 1).get(0));
    //设置创建人信息
    agreementLadder.setCreateAccount(loginUserService.getLoginAccountName());
    agreementLadder.setCreateTime(new Date());
    agreementLadder.setTenantCode(TenantUtils.getTenantCode());
    agreementLadder.setModifyAccount(agreementLadder.getCreateAccount());
    agreementLadder.setModifyTime(agreementLadder.getCreateTime());
    agreementLadder.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.agreementLadderRepository.save(agreementLadder);
    return agreementLadder;
  }

  /**
   * 分页查询数据
   *
   * @param pageable 分页信息
   * @param dto      查询条件
   * @return 协议阶梯
   */
  @Override
  public Page<AgreementLadder> findByConditions(Pageable pageable, AgreementLadderDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new AgreementLadderDto();
    }
    return this.agreementLadderRepository.findByConditions(pageable, dto);
  }

  @Override
  public void enableBatch(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选中要操作的数据");
    this.agreementLadderRepository.updateEnableStatusByIds(EnableStatusEnum.ENABLE, ids);
  }

  @Override
  public void disableBatch(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选中要操作的数据");
    this.agreementLadderRepository.updateEnableStatusByIds(EnableStatusEnum.DISABLE, ids);
  }

  @Override
  public AgreementLadder findByLadderCode(String ladderCode) {
    if (StringUtils.isBlank(ladderCode)) {
      return null;
    }
    return this.agreementLadderRepository.findByLadderCode(ladderCode);
  }

  /**
   * 协议阶梯创建校验
   *
   * @param agreementLadder 创建实体
   */
  private void validateAgreementLadder(AgreementLadder agreementLadder) {
    Validate.notNull(agreementLadder, "协议阶梯对象不能为空！");
    agreementLadder.setId(null);
    Validate.notBlank(agreementLadder.getLadderName(), "协议阶梯名称不能为空！");
    Validate.notBlank(agreementLadder.getLadderType(), "协议阶梯类别不能为空！");
    if (agreementLadder.getLadderType().equals(AgreementLadderTypeEnum.DISPLAY.getDictCode())) {
      //如果是陈列阶梯，则陈列面个数为必填
      Validate.notNull(agreementLadder.getDisplayNumber(), "陈列阶梯陈列面个数必须填写!");
    } else {
      //为包量阶梯，则每月销量数据和年度销量为必填
      Validate.notNull(agreementLadder.getJanuarySaleNum(), "包量阶梯一月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getFebruarySaleNum(), "包量阶梯二月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getMarchSaleNum(), "包量阶梯三月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getAprilSaleNum(), "包量阶梯四月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getMaySaleNum(), "包量阶梯五月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getJuneSaleNum(), "包量阶梯六月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getJulySaleNum(), "包量阶梯七月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getAugustSaleNum(), "包量阶梯八月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getSeptemberSaleNum(), "包量阶梯九月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getOctoberSaleNum(), "包量阶梯十月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getNovemberSaleNum(), "包量阶梯十一月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getDecemberSaleNum(), "包量阶梯十二月份销量目标不能为空!");
      Validate.notNull(agreementLadder.getYearSaleNum(), "包量阶梯年度销量目标不能为空!");
    }
  }
}
