package com.biz.crm.cps.business.agreement.local.service.internal;

import com.biz.crm.cps.business.agreement.local.entity.AgreementLadder;
import com.biz.crm.cps.business.agreement.local.repository.AgreementLadderRepository;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementLadderVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Set;

/**
 * 协议阶梯voService实现类
 *
 * @author songjingen
 */
@Service
public class AgreementLadderVoServiceImpl implements AgreementLadderVoService {

  @Resource
  private AgreementLadderRepository agreementLadderRepository;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public AgreementLadderVo findByLadderCode(String agreementLadderCode) {
    if (StringUtils.isBlank(agreementLadderCode)) {
      return null;
    } else {
      AgreementLadder agreementLadder = this.agreementLadderRepository.findByLadderCode(agreementLadderCode);
      return this.nebulaToolkitService.copyObjectByWhiteList(agreementLadder,AgreementLadderVo.class,Set.class,ArrayList.class);
    }
  }
}
