package com.biz.crm.cps.business.agreement.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.local.entity.AgreementSign;
import com.biz.crm.cps.business.agreement.local.repository.AgreementRepository;
import com.biz.crm.cps.business.agreement.local.repository.AgreementSignRepository;
import com.biz.crm.cps.business.agreement.local.service.AgreementSignService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignatoryEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;

/** 分利协议签署相关业务处理实现
 * @author songjingen
 */
@Service
public class AgreementSignServiceImpl implements AgreementSignService {

  @Resource
  private AgreementSignRepository agreementSignRepository;
  @Resource
  private AgreementRepository agreementRepository;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 协议签署新增（终端协议签署）
   * @param agreementSign
   * @return
   */
  @Transactional
  @Override
  public AgreementSign create(AgreementSign agreementSign) {
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser, "未查询到登录信息！");
    this.createValidation(agreementSign);
    //更改经销商签署状态
    agreementRepository.updateDealerSignStatusById(SignStatusEnum.SIGNED, agreementSign.getAgreementCode());
    //新增签署记录
    agreementSign.setSignatory(SignatoryEnum.DEALER.getDictCode());
    agreementSign.setSignDate(new Date());
    agreementSign.setTenantCode(TenantUtils.getTenantCode());
    agreementSign.setSignatoryName(loginUserService.getLoginAccountName());
    agreementSign.setSignatoryCode(loginUser.getUsername());
    agreementSign.setSignAccount(loginUserService.getLoginAccountName());
    agreementSignRepository.saveOrUpdate(agreementSign);
    return agreementSign;
  }

  /**
   * 新增操作时，先进行参数校验
   * @param agreementSign
   */
  private void createValidation(AgreementSign agreementSign) {
    //验证必填项，以及字段长度
    Validate.notNull(agreementSign, "新增操作时，新增对象不能为空！");
    Validate.notBlank(agreementSign.getAgreementCode(), "新增操作时，协议编码不能为空！");
    Validate.notBlank(agreementSign.getSignatureFilename(), "新增操作时，签名照片文件名不能为空！");
    Validate.notBlank(agreementSign.getSignaturePath(), "新增操作时，签名照片文件夹不能为空！");

    Validate.isTrue(agreementSign.getAgreementCode() == null || agreementSign.getAgreementCode().length() < 128, "协议编码，在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(agreementSign.getSignatureFilename() == null || agreementSign.getSignatureFilename().length() < 255, "协议名称，在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(agreementSign.getSignaturePath() == null || agreementSign.getSignaturePath().length() < 255, "所属协议模板，在进行添加时填入值超过了限定长度(255)，请检查!");
  }

}
