package com.biz.crm.cps.business.agreement.local.service.internal;

import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.service.ProfitAgreementTemplateService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateDetailsVoService;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateDetailsVo;
import com.biz.crm.cps.business.agreement.sdk.vo.TemplateTerminalRelationshipVo;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 协议政策详细信息service
 * @author hefan
 */
@Service
public class AgreementTemplateDetailsVoServiceImpl implements AgreementTemplateDetailsVoService {

  @Autowired
  private ProfitAgreementTemplateService profitAgreementTemplateService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private List<AgreementPolicyServiceObserver> agreementPolicyServiceObservers;

  @Autowired
  private TerminalVoService terminalVoService;

  @Override
  public AgreementTemplateDetailsVo findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    ProfitAgreementTemplate profitAgreementTemplate = profitAgreementTemplateService.findDetailsById(id);
    if (Objects.isNull(profitAgreementTemplate)) {
      return null;
    }
    String templateCode = profitAgreementTemplate.getTemplateCode();
    AgreementTemplateDetailsVo vo = this.nebulaToolkitService.copyObjectByWhiteList(profitAgreementTemplate, AgreementTemplateDetailsVo.class, HashSet.class, LinkedList.class
    ,"templateOrgRelationships","templatePolicyRelationships","templateTags","templateChannelRelationships","templateTerminalRelationships");
    //完善终端信息
    Set<TemplateTerminalRelationshipVo> templateTerminalRelationships = vo.getTemplateTerminalRelationships();
    if (!CollectionUtils.isEmpty(templateTerminalRelationships)) {
      List<String> codes = templateTerminalRelationships.stream().map(TemplateTerminalRelationshipVo::getTerminalCode).collect(Collectors.toList());
      List<TerminalVo> byTerminalCodes = this.terminalVoService.findByTerminalCodes(codes);
      if (!CollectionUtils.isEmpty(byTerminalCodes)) {
        List<TemplateTerminalRelationshipVo> templateTerminalRelationshipVos = (List<TemplateTerminalRelationshipVo>) this.nebulaToolkitService.copyCollectionByBlankList(byTerminalCodes, TerminalVo.class, TemplateTerminalRelationshipVo.class, HashSet.class, ArrayList.class);
        vo.setTemplateTerminalRelationships(new HashSet<>(templateTerminalRelationshipVos));
      }
    }
    List<AgreementPolicyVo> voList = Lists.newLinkedList();
    for (AgreementPolicyServiceObserver serviceObserver : agreementPolicyServiceObservers) {
      AgreementPolicyVo detailsByTemplateCode = serviceObserver.onFindDetailsByTemplateCode(templateCode);
      if (Objects.nonNull(detailsByTemplateCode)) {
        voList.add(detailsByTemplateCode);
      }
    }
    vo.setDetails(voList);
    return vo;
  }
}
