package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.entity.TemplateChannelRelationship;
import com.biz.crm.cps.business.agreement.local.entity.TemplateOrgRelationship;
import com.biz.crm.cps.business.agreement.local.entity.TemplatePolicyRelationship;
import com.biz.crm.cps.business.agreement.local.repository.AgreementRepository;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateRepository;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.common.sdk.constant.CommonConstant;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorTagVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author jerry7
 * @date 2021-08-05
 * 分离协议模板VO实现类
 */
@Service
@ConditionalOnMissingBean(name = "AgreementTemplateServiceVoExpandImpl")
public class AgreementTemplateVoServiceImpl implements AgreementTemplateVoService {

  @Autowired
  private ProfitAgreementTemplateRepository profitAgreementTemplateRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired
  private AgreementRepository agreementRepository;

  @Autowired
  private TerminalVoService terminalVoService;

  @Autowired
  private ParticipatorTagVoService participatorTagVoService;

  /**
   * 1、查询模板信息
   * 2、根据状态枚举转换模板启用状态名称
   * 3、如果关联渠道不为空，则用“，”拼接关联的渠道名称以做回显
   * 4、如果关联组织不为空，则用“，”拼接关联的渠道组织以做回显
   * 5、如果关联政策不为空，则用“，”拼接关联的政策名称以做回显
   *
   * @param pageable                             分页信息
   * @param profitAgreementTemplatePaginationDto 分页查询dto
   * @return
   */
  @Override
  public Page<AgreementTemplateVo> findByConditions(Pageable pageable, ProfitAgreementTemplatePaginationDto profitAgreementTemplatePaginationDto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (profitAgreementTemplatePaginationDto == null) {
      profitAgreementTemplatePaginationDto = new ProfitAgreementTemplatePaginationDto();
    }
    Page<ProfitAgreementTemplate> agreementTemplatePage = profitAgreementTemplateRepository.findByConditions(pageable, profitAgreementTemplatePaginationDto);
    Page<AgreementTemplateVo> agreementTemplateVoPage = this.buildAgreementTemplatePage(agreementTemplatePage);
    return agreementTemplateVoPage;
  }

  /**
   * 终端未签署展示的模板信息
   *
   * @param pageable 分页信息
   * @param dto      分页查询dto
   * @return
   */
  @Override
  public Page<AgreementTemplateVo> findListByConditions(Pageable pageable, ProfitAgreementTemplatePaginationDto dto) {
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    ;
    if (Objects.isNull(loginUser)) {
      return null;
    }
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new ProfitAgreementTemplatePaginationDto();
    }
    //查询终端信息
    ArrayList<String> list = new ArrayList<>();
    list.add(loginUser.getConsumerCode());
    List<TerminalVo> terminalVos = this.terminalVoService.findByTerminalCodes(list);
    if (CollectionUtils.isEmpty(terminalVos)) {
      return null;
    }
    TerminalVo terminalVo = terminalVos.get(0);
    //查询标签
    List<ParticipatorTagVo> tags = this.participatorTagVoService.findByParticipatorCodes(list);
    Set<String> tagSet = new HashSet<>();
    if (!CollectionUtils.isEmpty(tags)) {
      tagSet = tags.stream().map(ParticipatorTagVo::getTagDescription).collect(Collectors.toSet());
    }
    //查询当前用户所能看到的模板
    dto.setOrgCode(terminalVo.getOrganizationCode());
    dto.setChannelCode(terminalVo.getChannel());
    dto.setQueryFlag(CommonConstant.QUERY_FLAG_H5);
    dto.setStatus(EnableStatusEnum.ENABLE.getCode());
    dto.setTags(tagSet);
    dto.setTerminalCode(terminalVo.getTerminalCode());
    List<ProfitAgreementTemplate> byConditions = this.profitAgreementTemplateRepository.findByConditions(dto);
    if (CollectionUtils.isEmpty(byConditions)) {
      return null;
    }
    //筛选掉已经签署的模板
    List<String> templateCodes = byConditions.stream().map(ProfitAgreementTemplate::getTemplateCode).collect(Collectors.toList());
    List<Agreement> agreements = this.agreementRepository.findByTerminalCode(loginUser.getConsumerCode());
    if (!CollectionUtils.isEmpty(agreements)) {
      List<String> stringList = agreements.stream().map(Agreement::getTemplateCode).collect(Collectors.toList());
      templateCodes = templateCodes.stream().filter(s -> !stringList.contains(s)).collect(Collectors.toList());
    }
    //查询未签署的模板列表
    if (CollectionUtils.isEmpty(templateCodes)) {
      return null;
    }
    dto.setTemplateCodes(templateCodes);
    Page<ProfitAgreementTemplate> agreementTemplatePage = this.profitAgreementTemplateRepository.findByConditions(pageable, dto);
    if (Objects.isNull(agreementTemplatePage)) {
      return null;
    }
    Page<AgreementTemplateVo> agreementTemplateVoPage = this.buildAgreementTemplatePage(agreementTemplatePage);
    return agreementTemplateVoPage;
  }

  @Override
  public List<AgreementTemplateVo> findByConditions(ProfitAgreementTemplatePaginationDto profitAgreementTemplatePaginationDto) {
    if (profitAgreementTemplatePaginationDto == null) {
      profitAgreementTemplatePaginationDto = new ProfitAgreementTemplatePaginationDto();
    }
    List<ProfitAgreementTemplate> agreementTemplateList = profitAgreementTemplateRepository.findByConditions(profitAgreementTemplatePaginationDto);
    if(CollectionUtils.isEmpty(agreementTemplateList)){
      return Lists.newArrayList();
    }
    return (List<AgreementTemplateVo>) nebulaToolkitService.copyCollectionByWhiteList(agreementTemplateList,ProfitAgreementTemplate.class, AgreementTemplateVo.class, Set.class, ArrayList.class);
  }

  /**
   * 组装voPage
   *
   * @param agreementTemplatePage
   * @return
   */
  private Page<AgreementTemplateVo> buildAgreementTemplatePage(Page<ProfitAgreementTemplate> agreementTemplatePage) {
    List<AgreementTemplateVo> agreementTemplateVos = Lists.newArrayList();
    List<ProfitAgreementTemplate> records = agreementTemplatePage.getRecords();
    if (!CollectionUtils.isEmpty(records)) {
      records.forEach(agreementTemplate -> {
        AgreementTemplateVo agreementTemplateVo = nebulaToolkitService.copyObjectByWhiteList(agreementTemplate, AgreementTemplateVo.class, null, null);
        //根据状态枚举转换模板启用状态名称
        agreementTemplateVo.setEnableStatus(EnableStatusEnum.getDesc(agreementTemplate.getEnableStatus()));
        //如果关联渠道不为空，则用“，”拼接关联的渠道名称以做回显
        if (!CollectionUtils.isEmpty(agreementTemplate.getTemplateChannelRelationships())) {
          agreementTemplateVo.setTemplateChannelNameStr(agreementTemplate.getTemplateChannelRelationships()
              .stream()
              .map(TemplateChannelRelationship::getChannelName)
              .collect(Collectors.joining("，")));
        }
        //如果关联组织不为空，则用“，”拼接关联的渠道组织以做回显
        if (!CollectionUtils.isEmpty(agreementTemplate.getTemplateOrgRelationships())) {
          agreementTemplateVo.setTemplateOrgNameStr(agreementTemplate.getTemplateOrgRelationships()
              .stream()
              .map(TemplateOrgRelationship::getOrgName)
              .collect(Collectors.joining("，")));
        }
        //如果关联政策不为空，则用“，”拼接关联的政策名称以做回显
        if (!CollectionUtils.isEmpty(agreementTemplate.getTemplatePolicyRelationships())) {
          agreementTemplateVo.setTemplatePolicyNameStr(agreementTemplate.getTemplatePolicyRelationships()
              .stream()
              .map(TemplatePolicyRelationship::getPolicyName)
              .collect(Collectors.joining("，")));
        }
        //如果关联政策不为空，
        if (!CollectionUtils.isEmpty(agreementTemplate.getTemplatePolicyRelationships())) {
          agreementTemplateVo.setTemplatePolicyNames(agreementTemplate.getTemplatePolicyRelationships()
              .stream()
              .map(TemplatePolicyRelationship::getPolicyName)
              .collect(Collectors.toSet()));
        }
        agreementTemplateVos.add(agreementTemplateVo);
      });
    }
    Page<AgreementTemplateVo> agreementTemplateVoPage = new Page<AgreementTemplateVo>();
    agreementTemplateVoPage.setTotal(agreementTemplatePage.getTotal());
    agreementTemplateVoPage.setCurrent(agreementTemplatePage.getCurrent());
    agreementTemplateVoPage.setSize(agreementTemplatePage.getSize());
    agreementTemplateVoPage.setRecords(agreementTemplateVos);
    return agreementTemplateVoPage;
  }

}
