package com.biz.crm.cps.business.agreement.local.service.internal;

import com.biz.crm.cps.business.agreement.sdk.service.PolicyMountVoService;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyMountRegister;
import com.biz.crm.cps.business.agreement.sdk.vo.PolicyMountVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 协议政策挂载信息service
 * @author hefan
 */
@Service
public class PolicyMountVoServiceImpl implements PolicyMountVoService {

  @Autowired(required = false)
  private List<AgreementPolicyMountRegister> agreementPolicyMountRegister;

  @Override
  public List<PolicyMountVo> findPolicy() {
    if (CollectionUtils.isEmpty(agreementPolicyMountRegister)) {
      return null;
    }
    List<PolicyMountVo> list = Lists.newLinkedList();
    for (AgreementPolicyMountRegister policyMountRegister : agreementPolicyMountRegister) {
      PolicyMountVo vo = new PolicyMountVo();
      vo.setFlag(policyMountRegister.getFlag());
      vo.setKey(policyMountRegister.getKey());
      vo.setName(policyMountRegister.getName());
      list.add(vo);
    }
    return list;
  }
}
