package com.biz.crm.cps.business.agreement.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.service.PolicyRewardDataVoService;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.agreement.sdk.vo.PolicyRewardDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 政策奖励配置信息（奖励条件）VO service 实现类
 * @author hefan
 */
@Service
public class PolicyRewardDataVoServiceImpl implements PolicyRewardDataVoService {

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired
  private AgreementVoService agreementVoService;

  @Autowired(required = false)
  private List<AgreementPolicyServiceObserver> agreementPolicyServiceObserver;

  @Override
  public List<PolicyRewardDataVo> findPolicyRewardData() {
    /**
     * 获取当前登录人
     * 查询当前登录人生效的协议
     * 协议模板code去重
     * 查询模板集合的奖励条件
     */
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser, "未查询到当前登录信息！");
    Validate.notNull(loginUser.getConsumerCode(),"当前登录人的编码为空！");
    Validate.notNull(loginUser.getUsertype(),"当前登录人的类型为空！");
    //查询当前参与者的已生效的协议信息
    LoginUserAgreementDto loginUserAgreementDto = this.nebulaToolkitService.copyObjectByWhiteList(loginUser, LoginUserAgreementDto.class, HashSet.class, ArrayList.class);
    loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
    List<AgreementVo> agreementVos = agreementVoService.findByConditions(loginUserAgreementDto);
    if (CollectionUtils.isEmpty(agreementVos)) {
      return null;
    }
    Set<String> templateCodeSet = agreementVos.stream().map(AgreementVo::getTemplateCode).collect(Collectors.toSet());
    List<PolicyRewardDataVo> policyRewardDataVos = Lists.newLinkedList();
    if (!CollectionUtils.isEmpty(this.agreementPolicyServiceObserver)) {
      for (AgreementPolicyServiceObserver observer : this.agreementPolicyServiceObserver) {
        List<PolicyRewardDataVo> policyRewardData = observer.onFindPolicyRewardData(templateCodeSet, loginUser.getUsertype());
        if(!CollectionUtils.isEmpty(policyRewardData)){
          policyRewardDataVos.addAll(policyRewardData);
        }
      }
    }
    return policyRewardDataVos;
  }
}
