package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplateDetailLog;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateDetailLogRepository;
import com.biz.crm.cps.business.agreement.local.service.ProfitAgreementTemplateDetailLogService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 模板日志明细接口实现
 * @Author: zengxingwang
 * @Date: 2021/11/19 15:21
 */
@Service
public class ProfitAgreementTemplateDetailLogServiceImpl implements ProfitAgreementTemplateDetailLogService {

  @Autowired
  private ProfitAgreementTemplateDetailLogRepository profitAgreementTemplateDetailLogRepository;
  /**
   * 日志明细查询
   * @param pageable
   * @param logId
   * @return
   */
  @Override
  public Page<ProfitAgreementTemplateDetailLog> findByLogId(Pageable pageable, String logId) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if(StringUtils.isBlank(logId)){
      return new Page<>();
    }
    return this.profitAgreementTemplateDetailLogRepository.findByLogId(pageable, logId);
  }
}
