package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplateDetailLog;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplateLog;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateDetailLogRepository;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateLogRepository;
import com.biz.crm.cps.business.agreement.local.service.ProfitAgreementTemplateLogService;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplateLogDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * 模板日志接口实现
 * @Author: zengxingwang
 * @Date: 2021/11/19 11:34
 */
@Service
public class ProfitAgreementTemplateLogServiceImpl implements ProfitAgreementTemplateLogService {

  @Autowired
  private ProfitAgreementTemplateLogRepository profitAgreementTemplateLogRepository;
  @Autowired
  private ProfitAgreementTemplateDetailLogRepository profitAgreementTemplateDetailLogRepository;

  /**
   * 保存日志
   * @param templateLog
   * @return
   */
  @Override
  @Transactional
  public ProfitAgreementTemplateLog create(ProfitAgreementTemplateLog templateLog) {
    this.createValidate(templateLog);
    profitAgreementTemplateLogRepository.save(templateLog);
    //保存明细
    Set<ProfitAgreementTemplateDetailLog> agreementTemplateDetailLogs = templateLog.getAgreementTemplateDetailLogs();
    if(!CollectionUtils.isEmpty(agreementTemplateDetailLogs)){
      agreementTemplateDetailLogs.forEach(item -> item.setAgreementTemplateLogId(templateLog.getId()));
    }
    profitAgreementTemplateDetailLogRepository.saveBatch(agreementTemplateDetailLogs);
    return templateLog;
  }

  /**
   * 日志分页条件查询
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<ProfitAgreementTemplateLog> findByConditions(Pageable pageable, ProfitAgreementTemplateLogDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.profitAgreementTemplateLogRepository.findByConditions(pageable, dto);
  }

  /**
   * 保存验证
   * @param templateLog
   */
  private void createValidate(ProfitAgreementTemplateLog templateLog) {
    Validate.notNull(templateLog, "日志信息不能为空");
    Validate.notBlank(templateLog.getOperateType(), "操作类型不能为空");
  }
}
