/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.local.entity.AgreementLadder;
import com.biz.crm.cps.business.agreement.local.repository.AgreementLadderRepository;
import com.biz.crm.cps.business.agreement.local.service.AgreementLadderService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementLadderTypeEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementLadderDto;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AgreementLadderServiceImpl
implements AgreementLadderService {
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private AgreementLadderRepository agreementLadderRepository;

    @Override
    @Transactional
    public AgreementLadder create(AgreementLadder agreementLadder) {
        this.validateAgreementLadder(agreementLadder);
        agreementLadder.setLadderCode((String)this.generateCodeService.generateCode("agreementLadder", 1).get(0));
        agreementLadder.setCreateAccount(this.loginUserService.getLoginAccountName());
        agreementLadder.setCreateTime(new Date());
        agreementLadder.setTenantCode(TenantUtils.getTenantCode());
        agreementLadder.setModifyAccount(agreementLadder.getCreateAccount());
        agreementLadder.setModifyTime(agreementLadder.getCreateTime());
        agreementLadder.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.agreementLadderRepository.save((Object)agreementLadder);
        return agreementLadder;
    }

    @Override
    public Page<AgreementLadder> findByConditions(Pageable pageable, AgreementLadderDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AgreementLadderDto();
        }
        return this.agreementLadderRepository.findByConditions(pageable, dto);
    }

    @Override
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.agreementLadderRepository.updateEnableStatusByIds(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.agreementLadderRepository.updateEnableStatusByIds(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    public AgreementLadder findByLadderCode(String ladderCode) {
        if (StringUtils.isBlank((CharSequence)ladderCode)) {
            return null;
        }
        return this.agreementLadderRepository.findByLadderCode(ladderCode);
    }

    private void validateAgreementLadder(AgreementLadder agreementLadder) {
        Validate.notNull((Object)((Object)agreementLadder), (String)"\u534f\u8bae\u9636\u68af\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        agreementLadder.setId(null);
        Validate.notBlank((CharSequence)agreementLadder.getLadderName(), (String)"\u534f\u8bae\u9636\u68af\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)agreementLadder.getLadderType(), (String)"\u534f\u8bae\u9636\u68af\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (agreementLadder.getLadderType().equals(AgreementLadderTypeEnum.DISPLAY.getDictCode())) {
            Validate.notNull((Object)agreementLadder.getDisplayNumber(), (String)"\u9648\u5217\u9636\u68af\u9648\u5217\u9762\u4e2a\u6570\u5fc5\u987b\u586b\u5199!", (Object[])new Object[0]);
        } else {
            Validate.notNull((Object)agreementLadder.getJanuarySaleNum(), (String)"\u5305\u91cf\u9636\u68af\u4e00\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getFebruarySaleNum(), (String)"\u5305\u91cf\u9636\u68af\u4e8c\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getMarchSaleNum(), (String)"\u5305\u91cf\u9636\u68af\u4e09\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getAprilSaleNum(), (String)"\u5305\u91cf\u9636\u68af\u56db\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getMaySaleNum(), (String)"\u5305\u91cf\u9636\u68af\u4e94\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getJuneSaleNum(), (String)"\u5305\u91cf\u9636\u68af\u516d\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getJulySaleNum(), (String)"\u5305\u91cf\u9636\u68af\u4e03\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getAugustSaleNum(), (String)"\u5305\u91cf\u9636\u68af\u516b\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getSeptemberSaleNum(), (String)"\u5305\u91cf\u9636\u68af\u4e5d\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getOctoberSaleNum(), (String)"\u5305\u91cf\u9636\u68af\u5341\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getNovemberSaleNum(), (String)"\u5305\u91cf\u9636\u68af\u5341\u4e00\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getDecemberSaleNum(), (String)"\u5305\u91cf\u9636\u68af\u5341\u4e8c\u6708\u4efd\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)agreementLadder.getYearSaleNum(), (String)"\u5305\u91cf\u9636\u68af\u5e74\u5ea6\u9500\u91cf\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        }
    }
}

