/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.service.ProfitAgreementTemplateService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateDetailsVoService;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateDetailsVo;
import com.biz.crm.cps.business.agreement.sdk.vo.TemplateTerminalRelationshipVo;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgreementTemplateDetailsVoServiceImpl
implements AgreementTemplateDetailsVoService {
    @Autowired
    private ProfitAgreementTemplateService profitAgreementTemplateService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<AgreementPolicyServiceObserver> agreementPolicyServiceObservers;
    @Autowired
    private TerminalVoService terminalVoService;

    public AgreementTemplateDetailsVo findDetailsById(String id) {
        List codes;
        List byTerminalCodes;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProfitAgreementTemplate profitAgreementTemplate = this.profitAgreementTemplateService.findDetailsById(id);
        if (Objects.isNull((Object)profitAgreementTemplate)) {
            return null;
        }
        String templateCode = profitAgreementTemplate.getTemplateCode();
        AgreementTemplateDetailsVo vo = (AgreementTemplateDetailsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)profitAgreementTemplate, AgreementTemplateDetailsVo.class, HashSet.class, LinkedList.class, new String[]{"templateOrgRelationships", "templatePolicyRelationships", "templateTags", "templateChannelRelationships", "templateTerminalRelationships"});
        Set templateTerminalRelationships = vo.getTemplateTerminalRelationships();
        if (!CollectionUtils.isEmpty((Collection)templateTerminalRelationships) && !CollectionUtils.isEmpty((Collection)(byTerminalCodes = this.terminalVoService.findByTerminalCodes(codes = templateTerminalRelationships.stream().map(TemplateTerminalRelationshipVo::getTerminalCode).collect(Collectors.toList()))))) {
            List templateTerminalRelationshipVos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)byTerminalCodes, TerminalVo.class, TemplateTerminalRelationshipVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setTemplateTerminalRelationships(new HashSet(templateTerminalRelationshipVos));
        }
        LinkedList voList = Lists.newLinkedList();
        for (AgreementPolicyServiceObserver serviceObserver : this.agreementPolicyServiceObservers) {
            AgreementPolicyVo detailsByTemplateCode = serviceObserver.onFindDetailsByTemplateCode(templateCode);
            if (!Objects.nonNull(detailsByTemplateCode)) continue;
            voList.add(detailsByTemplateCode);
        }
        vo.setDetails((List)voList);
        return vo;
    }
}

