/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.entity.TemplateChannelRelationship;
import com.biz.crm.cps.business.agreement.local.entity.TemplateOrgRelationship;
import com.biz.crm.cps.business.agreement.local.entity.TemplatePolicyRelationship;
import com.biz.crm.cps.business.agreement.local.entity.TemplateTag;
import com.biz.crm.cps.business.agreement.local.entity.TemplateTerminalRelationship;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateRepository;
import com.biz.crm.cps.business.agreement.local.repository.TemplateChannelRelationshipRepository;
import com.biz.crm.cps.business.agreement.local.repository.TemplateOrgRelationshipRepository;
import com.biz.crm.cps.business.agreement.local.repository.TemplatePolicyRelationshipRepository;
import com.biz.crm.cps.business.agreement.local.repository.TemplateTagRepository;
import com.biz.crm.cps.business.agreement.local.repository.TemplateTerminalRelationshipRepository;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.local.service.ProfitAgreementTemplateService;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyMountRegister;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"ProfitAgreementTemplateServiceExpandImpl"})
public class AgreementTemplateServiceImpl
implements ProfitAgreementTemplateService {
    @Autowired
    private ProfitAgreementTemplateRepository profitAgreementTemplateRepository;
    @Autowired
    private TemplateOrgRelationshipRepository templateOrgRelationshipRepository;
    @Autowired
    private TemplatePolicyRelationshipRepository templatePolicyRelationshipRepository;
    @Autowired
    private TemplateChannelRelationshipRepository templateChannelRelationshipRepository;
    @Autowired
    private TemplateTagRepository templateTagRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private List<AgreementPolicyServiceObserver> agreementPolicyServiceObservers;
    @Autowired(required=false)
    private List<AgreementPolicyMountRegister> agreementPolicyMountRegisters;
    @Autowired
    private AgreementService agreementService;
    @Autowired
    private TemplateTerminalRelationshipRepository templateTerminalRelationshipRepository;

    @Override
    @Transactional
    public ProfitAgreementTemplate create(ProfitAgreementTemplate profitAgreementTemplate) {
        ProfitAgreementTemplate templateCurrent = this.createForm(profitAgreementTemplate);
        this.profitAgreementTemplateRepository.save((Object)templateCurrent);
        if (!CollectionUtils.isEmpty(templateCurrent.getTemplateOrgRelationships())) {
            templateCurrent.getTemplateOrgRelationships().forEach(templateOrgRelationship -> templateOrgRelationship.setTemplateCode(templateCurrent.getTemplateCode()));
            this.templateOrgRelationshipRepository.saveBatch(templateCurrent.getTemplateOrgRelationships());
        }
        if (!CollectionUtils.isEmpty(templateCurrent.getTemplatePolicyRelationships())) {
            templateCurrent.getTemplatePolicyRelationships().forEach(templatePolicyRelationship -> templatePolicyRelationship.setTemplateCode(templateCurrent.getTemplateCode()));
            this.templatePolicyRelationshipRepository.saveBatch(templateCurrent.getTemplatePolicyRelationships());
        }
        if (!CollectionUtils.isEmpty(templateCurrent.getTemplateTags())) {
            templateCurrent.getTemplateTags().forEach(templateTag -> templateTag.setTemplateCode(templateCurrent.getTemplateCode()));
            this.templateTagRepository.saveBatch(templateCurrent.getTemplateTags());
        }
        if (!CollectionUtils.isEmpty(templateCurrent.getTemplateChannelRelationships())) {
            templateCurrent.getTemplateChannelRelationships().forEach(channelRelationship -> channelRelationship.setTemplateCode(templateCurrent.getTemplateCode()));
            this.templateChannelRelationshipRepository.saveBatch(templateCurrent.getTemplateChannelRelationships());
        }
        if (!CollectionUtils.isEmpty(templateCurrent.getTemplateTerminalRelationships())) {
            templateCurrent.getTemplateTerminalRelationships().forEach(terminalRelationship -> terminalRelationship.setTemplateCode(templateCurrent.getTemplateCode()));
            this.templateTerminalRelationshipRepository.saveBatch(templateCurrent.getTemplateTerminalRelationships());
        }
        return profitAgreementTemplate;
    }

    @Override
    @Transactional
    public ProfitAgreementTemplate createForm(ProfitAgreementTemplate profitAgreementTemplate) {
        Validate.notNull((Object)((Object)profitAgreementTemplate), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        this.createValidation(profitAgreementTemplate);
        Date now = new Date();
        profitAgreementTemplate.setCreateTime(now);
        profitAgreementTemplate.setModifyTime(now);
        if (Objects.nonNull(this.generateCodeService)) {
            profitAgreementTemplate.setTemplateCode((String)this.generateCodeService.generateCode("agreement_template", 1).get(0));
        }
        profitAgreementTemplate.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        profitAgreementTemplate.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        profitAgreementTemplate.setTenantCode(TenantUtils.getTenantCode());
        profitAgreementTemplate.setCreateAccount(this.loginUserService.getLoginAccountName());
        profitAgreementTemplate.setModifyAccount(this.loginUserService.getLoginAccountName());
        return profitAgreementTemplate;
    }

    @Override
    public ProfitAgreementTemplate findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (ProfitAgreementTemplate)((Object)this.profitAgreementTemplateRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public ProfitAgreementTemplate findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.profitAgreementTemplateRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.profitAgreementTemplateRepository.updateEnableStatusByIds(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.profitAgreementTemplateRepository.updateEnableStatusByIds(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    @Transactional
    public ProfitAgreementTemplate create(JSONObject jsonObject) {
        ProfitAgreementTemplate profitAgreementTemplate = this.getProfitAgreementTemplate(jsonObject);
        this.create(profitAgreementTemplate);
        jsonObject.put("templateCode", (Object)profitAgreementTemplate.getTemplateCode());
        for (AgreementPolicyServiceObserver agreementPolicyServiceObserver : this.agreementPolicyServiceObservers) {
            agreementPolicyServiceObserver.onCreate(jsonObject);
        }
        return profitAgreementTemplate;
    }

    private ProfitAgreementTemplate getProfitAgreementTemplate(JSONObject jsonObject) {
        Validate.notNull((Object)jsonObject, (String)"\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u4fe1\u606f", (Object[])new Object[0]);
        JSONObject templateJson = jsonObject.getJSONObject("profitAgreementTemplate");
        Validate.notNull((Object)jsonObject, (String)"\u672a\u83b7\u53d6\u5230\u534f\u8bae\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        boolean hasPolicyData = false;
        for (AgreementPolicyMountRegister mountRegister : this.agreementPolicyMountRegisters) {
            Object policyData = jsonObject.get((Object)mountRegister.getKey());
            if (!Objects.nonNull(policyData)) continue;
            hasPolicyData = true;
            break;
        }
        Validate.isTrue((boolean)hasPolicyData, (String)"\u521b\u5efa\u6a21\u677f\u65f6\u9700\u8981\u6307\u5b9a\u653f\u7b56\u5185\u5bb9\uff01", (Object[])new Object[0]);
        ProfitAgreementTemplate profitAgreementTemplate = (ProfitAgreementTemplate)((Object)JsonUtils.json2Obj((String)templateJson.toJSONString(), ProfitAgreementTemplate.class));
        return profitAgreementTemplate;
    }

    @Override
    @Transactional
    public ProfitAgreementTemplate update(JSONObject jsonObject) {
        ProfitAgreementTemplate profitAgreementTemplate = this.getProfitAgreementTemplate(jsonObject);
        ProfitAgreementTemplate template = this.findById(profitAgreementTemplate.getId());
        Validate.notNull((Object)((Object)template), (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Date date = new Date();
        boolean before = date.before(template.getSignStartTime());
        profitAgreementTemplate = this.updateDetails(profitAgreementTemplate, template, before);
        jsonObject.put("templateCode", (Object)profitAgreementTemplate.getTemplateCode());
        jsonObject.put("before", (Object)before);
        for (AgreementPolicyServiceObserver agreementPolicyServiceObserver : this.agreementPolicyServiceObservers) {
            agreementPolicyServiceObserver.onChange(jsonObject);
        }
        return profitAgreementTemplate;
    }

    @Override
    public List<ProfitAgreementTemplate> findByTemplateCodes(Set<String> templateCodeSet) {
        if (CollectionUtils.isEmpty(templateCodeSet)) {
            return Lists.newLinkedList();
        }
        return this.profitAgreementTemplateRepository.findByTemplateCodes(templateCodeSet);
    }

    private ProfitAgreementTemplate updateDetails(ProfitAgreementTemplate profitAgreementTemplate, ProfitAgreementTemplate template, Boolean before) {
        if (before.booleanValue()) {
            BeanUtils.copyProperties((Object)((Object)profitAgreementTemplate), (Object)((Object)template), (String[])new String[]{"id", "templateCode", "tenantCode", "delFlag", "enableStatus", "createAccount", "createTime"});
        } else {
            template.setPermissionType(profitAgreementTemplate.getPermissionType());
            template.setTemplateName(profitAgreementTemplate.getTemplateName());
            template.setAgreementText(profitAgreementTemplate.getAgreementText());
        }
        template.setModifyAccount(((LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class)).getConsumerName());
        template.setModifyTime(new Date());
        template.setTemplatePolicyRelationships(profitAgreementTemplate.getTemplatePolicyRelationships());
        this.updateValidation(template);
        this.profitAgreementTemplateRepository.updateById((Object)template);
        String templateCode = template.getTemplateCode();
        this.templateOrgRelationshipRepository.deleteByTemplateCode(templateCode);
        Set<TemplateOrgRelationship> templateOrgRelationships = profitAgreementTemplate.getTemplateOrgRelationships();
        if (!CollectionUtils.isEmpty(templateOrgRelationships)) {
            templateOrgRelationships.forEach(templateOrgRelationship -> templateOrgRelationship.setTemplateCode(templateCode));
            this.templateOrgRelationshipRepository.saveBatch(templateOrgRelationships);
            template.setTemplateOrgRelationships(templateOrgRelationships);
        }
        Set<TemplatePolicyRelationship> templatePolicyRelationships = profitAgreementTemplate.getTemplatePolicyRelationships();
        if (before.booleanValue()) {
            this.templatePolicyRelationshipRepository.deleteByTemplateCode(templateCode);
            if (!CollectionUtils.isEmpty(templatePolicyRelationships)) {
                templatePolicyRelationships.forEach(templatePolicyRelationship -> templatePolicyRelationship.setTemplateCode(templateCode));
                this.templatePolicyRelationshipRepository.saveBatch(templatePolicyRelationships);
                template.setTemplatePolicyRelationships(templatePolicyRelationships);
            }
        } else {
            List<TemplatePolicyRelationship> oldList = this.templatePolicyRelationshipRepository.findByTemplateCode(templateCode);
            Set oldSet = oldList.stream().map(TemplatePolicyRelationship::getPolicyCode).collect(Collectors.toSet());
            Set newSet = templatePolicyRelationships.stream().map(TemplatePolicyRelationship::getPolicyCode).collect(Collectors.toSet());
            newSet.retainAll(oldSet);
            Validate.isTrue((newSet.size() == oldSet.size() ? 1 : 0) != 0, (String)"\u4fee\u6539\u6a21\u677f\u65f6\uff0c\u653f\u7b56\u4e0d\u80fd\u6539\u53d8\uff01", (Object[])new Object[0]);
        }
        this.templateTagRepository.deleteByTemplateCode(templateCode);
        Set<TemplateTag> templateTags = profitAgreementTemplate.getTemplateTags();
        if (!CollectionUtils.isEmpty(templateTags)) {
            templateTags.forEach(templateTag -> templateTag.setTemplateCode(templateCode));
            this.templateTagRepository.saveBatch(templateTags);
            template.setTemplateTags(templateTags);
        }
        this.templateChannelRelationshipRepository.deleteByTemplateCode(templateCode);
        Set<TemplateChannelRelationship> templateChannelRelationships = profitAgreementTemplate.getTemplateChannelRelationships();
        if (!CollectionUtils.isEmpty(templateChannelRelationships)) {
            templateChannelRelationships.forEach(channelRelationship -> channelRelationship.setTemplateCode(templateCode));
            this.templateChannelRelationshipRepository.saveBatch(templateChannelRelationships);
            template.setTemplateChannelRelationships(templateChannelRelationships);
        }
        this.templateTerminalRelationshipRepository.deleteByTemplateCode(templateCode);
        Set<TemplateTerminalRelationship> templateTerminalRelationships = profitAgreementTemplate.getTemplateTerminalRelationships();
        if (!CollectionUtils.isEmpty(templateTerminalRelationships)) {
            templateTerminalRelationships.forEach(terminalRelationship -> terminalRelationship.setTemplateCode(templateCode));
            this.templateTerminalRelationshipRepository.saveBatch(templateTerminalRelationships);
            template.setTemplateTerminalRelationships(templateTerminalRelationships);
        }
        return template;
    }

    private void createValidation(ProfitAgreementTemplate profitAgreementTemplate) {
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)profitAgreementTemplate.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        profitAgreementTemplate.setId(null);
        Validate.notBlank((CharSequence)profitAgreementTemplate.getTemplateName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)profitAgreementTemplate.getAgreementText(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u534f\u8bae\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)profitAgreementTemplate.getEffectiveStartTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u6a21\u677f\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)profitAgreementTemplate.getEffectiveEndTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u6a21\u677f\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)profitAgreementTemplate.getSignStartTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u6a21\u677f\u7b7e\u7f72\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)profitAgreementTemplate.getSignEndTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u6a21\u677f\u7b7e\u7f72\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)profitAgreementTemplate.getAutoSign(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u6a21\u677f\u662f\u5426\u81ea\u52a8\u7b7e\u7f72\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(profitAgreementTemplate.getTemplatePolicyRelationships(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u6a21\u677f\u5305\u542b\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((profitAgreementTemplate.getTemplateName() == null || profitAgreementTemplate.getTemplateName().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((boolean)profitAgreementTemplate.getEffectiveEndTime().after(profitAgreementTemplate.getEffectiveStartTime()), (String)"\u5206\u5229\u6a21\u677f\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u5f00\u59cb\u65f6\u95f4\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)profitAgreementTemplate.getSignEndTime().after(profitAgreementTemplate.getSignStartTime()), (String)"\u5206\u5229\u6a21\u677f\u7b7e\u7f72\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b7e\u7f72\u5f00\u59cb\u65f6\u95f4\uff01", (Object[])new Object[0]);
        Validate.isTrue((profitAgreementTemplate.getEffectiveEndTime().getTime() >= profitAgreementTemplate.getSignEndTime().getTime() ? 1 : 0) != 0, (String)"\u5206\u5229\u6a21\u677f\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b7e\u7f72\u7ed3\u675f\u65f6\u95f4\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(profitAgreementTemplate.getTemplatePolicyRelationships()) ? 1 : 0) != 0, (String)"\u6a21\u677f\u5fc5\u987b\u6307\u5b9a\u81f3\u5c11\u4e00\u6761\u653f\u7b56\uff01", (Object[])new Object[0]);
    }

    private void updateValidation(ProfitAgreementTemplate profitAgreementTemplate) {
        Validate.notNull((Object)profitAgreementTemplate.getId(), (String)"\u505a\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)profitAgreementTemplate.getTemplateName(), (String)"\u505a\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5206\u5229\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)profitAgreementTemplate.getAgreementText(), (String)"\u505a\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u534f\u8bae\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)profitAgreementTemplate.getEffectiveStartTime(), (String)"\u505a\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5206\u5229\u6a21\u677f\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)profitAgreementTemplate.getEffectiveEndTime(), (String)"\u505a\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5206\u5229\u6a21\u677f\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)profitAgreementTemplate.getSignStartTime(), (String)"\u505a\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5206\u5229\u6a21\u677f\u7b7e\u7f72\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)profitAgreementTemplate.getSignEndTime(), (String)"\u505a\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5206\u5229\u6a21\u677f\u7b7e\u7f72\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)profitAgreementTemplate.getAutoSign(), (String)"\u505a\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5206\u5229\u6a21\u677f\u662f\u5426\u81ea\u52a8\u7b7e\u7f72\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(profitAgreementTemplate.getTemplatePolicyRelationships(), (String)"\u505a\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5206\u5229\u6a21\u677f\u5305\u542b\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((profitAgreementTemplate.getTemplateName() == null || profitAgreementTemplate.getTemplateName().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((boolean)profitAgreementTemplate.getEffectiveEndTime().after(profitAgreementTemplate.getEffectiveStartTime()), (String)"\u5206\u5229\u6a21\u677f\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u5f00\u59cb\u65f6\u95f4\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)profitAgreementTemplate.getSignEndTime().after(profitAgreementTemplate.getSignStartTime()), (String)"\u5206\u5229\u6a21\u677f\u7b7e\u7f72\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b7e\u7f72\u5f00\u59cb\u65f6\u95f4\uff01", (Object[])new Object[0]);
        Validate.isTrue((profitAgreementTemplate.getEffectiveEndTime().getTime() >= profitAgreementTemplate.getSignEndTime().getTime() ? 1 : 0) != 0, (String)"\u5206\u5229\u6a21\u677f\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b7e\u7f72\u7ed3\u675f\u65f6\u95f4\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(profitAgreementTemplate.getTemplatePolicyRelationships()) ? 1 : 0) != 0, (String)"\u6a21\u677f\u5fc5\u987b\u6307\u5b9a\u81f3\u5c11\u4e00\u6761\u653f\u7b56\uff01", (Object[])new Object[0]);
    }
}

