/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.entity.TemplateChannelRelationship;
import com.biz.crm.cps.business.agreement.local.entity.TemplateOrgRelationship;
import com.biz.crm.cps.business.agreement.local.entity.TemplatePolicyRelationship;
import com.biz.crm.cps.business.agreement.local.repository.AgreementRepository;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateRepository;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorTagVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"AgreementTemplateServiceVoExpandImpl"})
public class AgreementTemplateVoServiceImpl
implements AgreementTemplateVoService {
    @Autowired
    private ProfitAgreementTemplateRepository profitAgreementTemplateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private AgreementRepository agreementRepository;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private ParticipatorTagVoService participatorTagVoService;

    public Page<AgreementTemplateVo> findByConditions(Pageable pageable, ProfitAgreementTemplatePaginationDto profitAgreementTemplatePaginationDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (profitAgreementTemplatePaginationDto == null) {
            profitAgreementTemplatePaginationDto = new ProfitAgreementTemplatePaginationDto();
        }
        Page<ProfitAgreementTemplate> agreementTemplatePage = this.profitAgreementTemplateRepository.findByConditions(pageable, profitAgreementTemplatePaginationDto);
        Page<AgreementTemplateVo> agreementTemplateVoPage = this.buildAgreementTemplatePage(agreementTemplatePage);
        return agreementTemplateVoPage;
    }

    public Page<AgreementTemplateVo> findListByConditions(Pageable pageable, ProfitAgreementTemplatePaginationDto dto) {
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        if (Objects.isNull(loginUser)) {
            return null;
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ProfitAgreementTemplatePaginationDto();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(loginUser.getConsumerCode());
        List terminalVos = this.terminalVoService.findByTerminalCodes(list);
        if (CollectionUtils.isEmpty((Collection)terminalVos)) {
            return null;
        }
        TerminalVo terminalVo = (TerminalVo)terminalVos.get(0);
        List tags = this.participatorTagVoService.findByParticipatorCodes(list);
        Set<Object> tagSet = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)tags)) {
            tagSet = tags.stream().map(ParticipatorTagVo::getTagDescription).collect(Collectors.toSet());
        }
        dto.setOrgCode(terminalVo.getOrganizationCode());
        dto.setChannelCode(terminalVo.getChannel());
        dto.setQueryFlag("H5");
        dto.setStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTags(tagSet);
        dto.setTerminalCode(terminalVo.getTerminalCode());
        List<ProfitAgreementTemplate> byConditions = this.profitAgreementTemplateRepository.findByConditions(dto);
        if (CollectionUtils.isEmpty(byConditions)) {
            return null;
        }
        List templateCodes = byConditions.stream().map(ProfitAgreementTemplate::getTemplateCode).collect(Collectors.toList());
        List<Agreement> agreements = this.agreementRepository.findByTerminalCode(loginUser.getConsumerCode());
        if (!CollectionUtils.isEmpty(agreements)) {
            List stringList = agreements.stream().map(Agreement::getTemplateCode).collect(Collectors.toList());
            templateCodes = templateCodes.stream().filter(s -> !stringList.contains(s)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(templateCodes)) {
            return null;
        }
        dto.setTemplateCodes(templateCodes);
        Page<ProfitAgreementTemplate> agreementTemplatePage = this.profitAgreementTemplateRepository.findByConditions(pageable, dto);
        if (Objects.isNull(agreementTemplatePage)) {
            return null;
        }
        Page<AgreementTemplateVo> agreementTemplateVoPage = this.buildAgreementTemplatePage(agreementTemplatePage);
        return agreementTemplateVoPage;
    }

    public List<AgreementTemplateVo> findByConditions(ProfitAgreementTemplatePaginationDto profitAgreementTemplatePaginationDto) {
        List<ProfitAgreementTemplate> agreementTemplateList;
        if (profitAgreementTemplatePaginationDto == null) {
            profitAgreementTemplatePaginationDto = new ProfitAgreementTemplatePaginationDto();
        }
        if (CollectionUtils.isEmpty(agreementTemplateList = this.profitAgreementTemplateRepository.findByConditions(profitAgreementTemplatePaginationDto))) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(agreementTemplateList, ProfitAgreementTemplate.class, AgreementTemplateVo.class, Set.class, ArrayList.class, new String[0]);
    }

    private Page<AgreementTemplateVo> buildAgreementTemplatePage(Page<ProfitAgreementTemplate> agreementTemplatePage) {
        ArrayList agreementTemplateVos = Lists.newArrayList();
        List records = agreementTemplatePage.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            records.forEach(agreementTemplate -> {
                AgreementTemplateVo agreementTemplateVo = (AgreementTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreementTemplate, AgreementTemplateVo.class, null, null, new String[0]);
                agreementTemplateVo.setEnableStatus(EnableStatusEnum.getDesc((String)agreementTemplate.getEnableStatus()));
                if (!CollectionUtils.isEmpty(agreementTemplate.getTemplateChannelRelationships())) {
                    agreementTemplateVo.setTemplateChannelNameStr(agreementTemplate.getTemplateChannelRelationships().stream().map(TemplateChannelRelationship::getChannelName).collect(Collectors.joining("\uff0c")));
                }
                if (!CollectionUtils.isEmpty(agreementTemplate.getTemplateOrgRelationships())) {
                    agreementTemplateVo.setTemplateOrgNameStr(agreementTemplate.getTemplateOrgRelationships().stream().map(TemplateOrgRelationship::getOrgName).collect(Collectors.joining("\uff0c")));
                }
                if (!CollectionUtils.isEmpty(agreementTemplate.getTemplatePolicyRelationships())) {
                    agreementTemplateVo.setTemplatePolicyNameStr(agreementTemplate.getTemplatePolicyRelationships().stream().map(TemplatePolicyRelationship::getPolicyName).collect(Collectors.joining("\uff0c")));
                }
                if (!CollectionUtils.isEmpty(agreementTemplate.getTemplatePolicyRelationships())) {
                    agreementTemplateVo.setTemplatePolicyNames(agreementTemplate.getTemplatePolicyRelationships().stream().map(TemplatePolicyRelationship::getPolicyName).collect(Collectors.toSet()));
                }
                agreementTemplateVos.add(agreementTemplateVo);
            });
        }
        Page agreementTemplateVoPage = new Page();
        agreementTemplateVoPage.setTotal(agreementTemplatePage.getTotal());
        agreementTemplateVoPage.setCurrent(agreementTemplatePage.getCurrent());
        agreementTemplateVoPage.setSize(agreementTemplatePage.getSize());
        agreementTemplateVoPage.setRecords((List)agreementTemplateVos);
        return agreementTemplateVoPage;
    }
}

