/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.service.PolicyRewardDataVoService;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.agreement.sdk.vo.PolicyRewardDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PolicyRewardDataVoServiceImpl
implements PolicyRewardDataVoService {
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired(required=false)
    private List<AgreementPolicyServiceObserver> agreementPolicyServiceObserver;

    public List<PolicyRewardDataVo> findPolicyRewardData() {
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loginUser.getConsumerCode(), (String)"\u5f53\u524d\u767b\u5f55\u4eba\u7684\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loginUser.getUsertype(), (String)"\u5f53\u524d\u767b\u5f55\u4eba\u7684\u7c7b\u578b\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        LoginUserAgreementDto loginUserAgreementDto = (LoginUserAgreementDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)loginUser, LoginUserAgreementDto.class, HashSet.class, ArrayList.class, new String[0]);
        loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        List agreementVos = this.agreementVoService.findByConditions(loginUserAgreementDto);
        if (CollectionUtils.isEmpty((Collection)agreementVos)) {
            return null;
        }
        Set templateCodeSet = agreementVos.stream().map(AgreementVo::getTemplateCode).collect(Collectors.toSet());
        LinkedList policyRewardDataVos = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty(this.agreementPolicyServiceObserver)) {
            for (AgreementPolicyServiceObserver observer : this.agreementPolicyServiceObserver) {
                List policyRewardData = observer.onFindPolicyRewardData(templateCodeSet, loginUser.getUsertype());
                if (CollectionUtils.isEmpty((Collection)policyRewardData)) continue;
                policyRewardDataVos.addAll(policyRewardData);
            }
        }
        return policyRewardDataVos;
    }
}

