/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplateDetailLog;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplateLog;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateDetailLogRepository;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateLogRepository;
import com.biz.crm.cps.business.agreement.local.service.ProfitAgreementTemplateLogService;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplateLogDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ProfitAgreementTemplateLogServiceImpl
implements ProfitAgreementTemplateLogService {
    @Autowired
    private ProfitAgreementTemplateLogRepository profitAgreementTemplateLogRepository;
    @Autowired
    private ProfitAgreementTemplateDetailLogRepository profitAgreementTemplateDetailLogRepository;

    @Override
    @Transactional
    public ProfitAgreementTemplateLog create(ProfitAgreementTemplateLog templateLog) {
        this.createValidate(templateLog);
        this.profitAgreementTemplateLogRepository.save((Object)templateLog);
        Set<ProfitAgreementTemplateDetailLog> agreementTemplateDetailLogs = templateLog.getAgreementTemplateDetailLogs();
        if (!CollectionUtils.isEmpty(agreementTemplateDetailLogs)) {
            agreementTemplateDetailLogs.forEach(item -> item.setAgreementTemplateLogId(templateLog.getId()));
        }
        this.profitAgreementTemplateDetailLogRepository.saveBatch(agreementTemplateDetailLogs);
        return templateLog;
    }

    @Override
    public Page<ProfitAgreementTemplateLog> findByConditions(Pageable pageable, ProfitAgreementTemplateLogDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.profitAgreementTemplateLogRepository.findByConditions(pageable, dto);
    }

    private void createValidate(ProfitAgreementTemplateLog templateLog) {
        Validate.notNull((Object)((Object)templateLog), (String)"\u65e5\u5fd7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateLog.getOperateType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

