/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.controller;

import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignDto;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/agreement/agreement"})
@Api(tags={"\u5206\u5229\u534f\u8bae\u4fe1\u606f"})
public class AgreementController {
    private static final Logger log = LoggerFactory.getLogger(AgreementController.class);
    @Autowired
    private AgreementService agreementService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u5229\u534f\u8bae\u57fa\u672c\u4fe1\u606f\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    public Result<Agreement> findById(@PathVariable @ApiParam(name="id", value="\u5206\u5229\u534f\u8bae\u4e3b\u952eid") String id) {
        try {
            Agreement agreement = this.agreementService.findById(id);
            return Result.ok((Object)((Object)agreement));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u7b7e\u7f72\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody @ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") List<String> ids) {
        try {
            this.agreementService.enable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u7ec8\u6b62\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody @ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") List<String> ids) {
        try {
            this.agreementService.disable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u534f\u8bae\u65b0\u589e\uff08\u7ec8\u7aef\u7b7e\u7f72\uff09")
    @PostMapping
    public Result<Agreement> create(@RequestBody @ApiParam(name="agreement", value="\u5206\u5229\u534f\u8bae\u4fe1\u606f") AgreementSignDto dto) {
        try {
            Agreement current = this.agreementService.create(dto);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u5229\u534f\u8bae\u57fa\u672c\u4fe1\u606f\u8be6\u60c5\u5305\u542b\u7b7e\u7f72\u60c5\u51b5")
    @GetMapping(value={"/findDetailsById"})
    public Result<Agreement> findDetailsById(@RequestParam(value="id") @ApiParam(name="id", value="\u5206\u5229\u534f\u8bae\u4e3b\u952eid") String id) {
        try {
            Agreement agreement = this.agreementService.findDetailsById(id);
            return Result.ok((Object)((Object)agreement));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u64a4\u9500\u7ec8\u6b62\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    @PatchMapping(value={"/revoke"})
    public Result<?> revoke(@RequestBody @ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") List<String> ids) {
        try {
            this.agreementService.revoke(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

