/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.mapper.ProfitAgreementTemplateMapper;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementTemplateExternalPageDto;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.cps.business.agreement.sdk.dto.QuantifyRangeDto;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateExternalVo;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProfitAgreementTemplateRepository
extends ServiceImpl<ProfitAgreementTemplateMapper, ProfitAgreementTemplate> {
    @Resource
    private ProfitAgreementTemplateMapper profitAgreementTemplateMapper;

    public ProfitAgreementTemplate findDetailsById(String id) {
        return this.profitAgreementTemplateMapper.findDetailsById(id);
    }

    public Page<ProfitAgreementTemplate> findByConditions(Pageable pageable, ProfitAgreementTemplatePaginationDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.profitAgreementTemplateMapper.findByConditions((Page<ProfitAgreementTemplate>)page, dto);
    }

    public List<ProfitAgreementTemplate> findByConditions(ProfitAgreementTemplatePaginationDto dto) {
        return this.profitAgreementTemplateMapper.findByConditions(dto);
    }

    public List<QuantifyRangeDto> findListForConfirmQuantify(ProfitAgreementTemplatePaginationDto dto) {
        return this.profitAgreementTemplateMapper.findListForConfirmQuantify(dto);
    }

    public void updateEnableStatusByIds(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public ProfitAgreementTemplate findByTemplateCode(String templateCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"template_code", (Object)templateCode);
        return (ProfitAgreementTemplate)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public List<ProfitAgreementTemplate> findByIds(List<String> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", ids);
        return this.list((Wrapper)queryWrapper);
    }

    public Page<AgreementTemplateExternalVo> findExternalPage(Pageable pageable, AgreementTemplateExternalPageDto pageDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.profitAgreementTemplateMapper.findExternalPage((Page<ProfitAgreementTemplate>)page, pageDto);
    }

    public List<QuantifyRangeDto> findQuantifyProductByTemplateCode(List<String> templateCodeList) {
        if (CollectionUtils.isEmpty(templateCodeList)) {
            return new ArrayList<QuantifyRangeDto>();
        }
        return this.profitAgreementTemplateMapper.findQuantifyProductByTemplateCode(templateCodeList);
    }

    public List<String> findTagListByTemplateCode(String templateCode) {
        return this.profitAgreementTemplateMapper.findTagListByTemplateCode(templateCode);
    }

    public List<String> findChannelListByTemplateCode(String templateCode) {
        return this.profitAgreementTemplateMapper.findChannelListByTemplateCode(templateCode);
    }

    public List<String> findTerminalCodeListByTemplateCode(String templateCode) {
        return this.profitAgreementTemplateMapper.findTerminalCodeListByTemplateCode(templateCode);
    }

    public List<String> findOrgCodeListByTemplateCode(String templateCode) {
        return this.profitAgreementTemplateMapper.findOrgCodeListByTemplateCode(templateCode);
    }
}

