/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.entity.AgreementSign;
import com.biz.crm.cps.business.agreement.local.entity.AgreementSignProduct;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.mapper.AgreementMapper;
import com.biz.crm.cps.business.agreement.local.repository.AgreementRepository;
import com.biz.crm.cps.business.agreement.local.repository.AgreementSignProductRepository;
import com.biz.crm.cps.business.agreement.local.repository.AgreementSignRepository;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateRepository;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AutoSignEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignatoryEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignEventDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.QuantifyRangeDto;
import com.biz.crm.cps.business.agreement.sdk.dto.ScanCodeAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementSignNumConfirmObserver;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementSignNumSaveObserver;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementSignObserver;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.SupplyRelationshipVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AgreementServiceImpl
implements AgreementService {
    @Autowired
    private AgreementRepository agreementRepository;
    @Autowired
    private AgreementSignRepository agreementSignRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private DealerVoService dealerVoService;
    @Autowired
    private ProfitAgreementTemplateRepository profitAgreementTemplateRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<AgreementSignObserver> agreementSignObservers;
    @Autowired(required=false)
    private List<AgreementSignNumConfirmObserver> agreementSignNumConfirmObservers;
    @Autowired(required=false)
    private List<AgreementSignNumSaveObserver> agreementSignNumSaveObservers;
    @Autowired
    private AgreementSignProductRepository agreementSignProductRepository;

    @Override
    @Transactional
    public void enable(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<Agreement> agreements = this.agreementRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(agreements) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8981\u7b7e\u7f72\u7684\u534f\u8bae", (Object[])new Object[0]);
        List<Agreement> collect = agreements.stream().filter(agreement -> SignStatusEnum.SIGNING.getCode().equals(agreement.getSignStatus())).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(collect) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8981\u7b7e\u7f72\u7684\u534f\u8bae", (Object[])new Object[0]);
        ArrayList agreementSigns = new ArrayList();
        Date date = new Date();
        collect.forEach(agreement -> {
            agreement.setSignStatus(SignStatusEnum.SIGNED.getCode());
            AgreementSign agreementSign = new AgreementSign();
            agreementSign.setId(null);
            agreementSign.setSignatory(SignatoryEnum.DEALER.getDictCode());
            agreementSign.setSignatoryCode(this.loginUserService.getLoginAccountName());
            agreementSign.setSignatoryName(this.loginUserService.getLoginAccountName());
            agreementSign.setSignDate(date);
            agreementSign.setSignAccount(this.loginUserService.getLoginAccountName());
            agreementSign.setTenantCode(TenantUtils.getTenantCode());
            agreementSign.setAgreementCode(agreement.getAgreementCode());
            agreementSigns.add(agreementSign);
        });
        this.agreementRepository.saveOrUpdateBatch(collect);
        this.agreementSignRepository.saveOrUpdateBatch(agreementSigns);
        collect.stream().forEach(agreement -> this.notifyEvent((Agreement)((Object)agreement)));
    }

    @Override
    @Transactional
    public void disable(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<Agreement> agreements = this.agreementRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(agreements) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8981\u7ec8\u6b62\u7684\u534f\u8bae", (Object[])new Object[0]);
        List<String> newIds = agreements.stream().filter(agreement -> SignStatusEnum.SIGNED.getCode().equals(agreement.getSignStatus())).map(BaseIdEntity::getId).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(newIds) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8981\u7ec8\u6b62\u7684\u534f\u8bae", (Object[])new Object[0]);
        this.agreementRepository.updateAgreementStatusByIds(AgreementStatusEnum.TERMINATED, newIds);
    }

    @Override
    @Transactional
    public void disableByTemplateCodes(List<String> templateCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(templateCodes) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<Agreement> agreementList = this.findByTemplateCodes(templateCodes);
        Validate.isTrue((!CollectionUtils.isEmpty(agreementList) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8981\u7ec8\u6b62\u7684\u534f\u8bae", (Object[])new Object[0]);
        agreementList.stream().forEach(agreement -> agreement.setAgreementStatus(AgreementStatusEnum.TERMINATED.getCode()));
        this.agreementRepository.saveOrUpdateBatch(agreementList);
    }

    @Override
    @Transactional
    public Agreement create(AgreementSignDto dto) {
        ProfitAgreementTemplate profitAgreementTemplate;
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        Validate.notNull((Object)loginUser, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
        this.createValidation(dto);
        Agreement agreement = this.createForm(dto, loginUser);
        this.agreementRepository.saveOrUpdate((Object)agreement);
        List<AgreementSign> agreementSigns = this.createAgreementSignForm(dto, loginUser, agreement);
        this.agreementSignRepository.saveBatch(agreementSigns);
        if (SignStatusEnum.SIGNED.getCode().equals(agreement.getSignStatus())) {
            this.notifyEvent(agreement);
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{profitAgreementTemplate = this.profitAgreementTemplateRepository.findByTemplateCode(dto.getTemplateCode())})) {
            Integer generatedAgreementNumber = profitAgreementTemplate.getGeneratedAgreementNumber();
            Integer n = generatedAgreementNumber = Integer.valueOf(Objects.isNull(generatedAgreementNumber) ? 0 : generatedAgreementNumber);
            Integer n2 = generatedAgreementNumber = Integer.valueOf(generatedAgreementNumber + 1);
            profitAgreementTemplate.setGeneratedAgreementNumber(generatedAgreementNumber);
            this.profitAgreementTemplateRepository.updateById((Object)profitAgreementTemplate);
        }
        return agreement;
    }

    @Override
    @Transactional
    public List<Agreement> customerCreateBatch(AgreementSignDto dto) {
        ProfitAgreementTemplate profitAgreementTemplate;
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        Validate.notNull((Object)loginUser, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
        this.createValidationBatch(dto);
        List<Agreement> agreementList = this.createFormBatch(dto);
        this.agreementRepository.saveBatch(agreementList);
        if (!CollectionUtils.isEmpty((Collection)dto.getQuantifyRangeList())) {
            ArrayList agreementSignProductList = new ArrayList(dto.getQuantifyRangeList().size());
            dto.getQuantifyRangeList().forEach(item -> agreementList.forEach(agreement -> {
                AgreementSignProduct agreementSignProduct = new AgreementSignProduct();
                agreementSignProduct.setAgreementId(agreement.getId());
                agreementSignProduct.setAgreementCode(agreement.getAgreementCode());
                agreementSignProduct.setSpecialCode(item.getSpecialCode());
                agreementSignProduct.setSpecialName(item.getSpecialName());
                agreementSignProduct.setSignNum(item.getSignNum());
                agreementSignProductList.add(agreementSignProduct);
            }));
            this.agreementSignProductRepository.saveBatch(agreementSignProductList);
        }
        if (!CollectionUtils.isEmpty(this.agreementSignNumSaveObservers)) {
            ArrayList agreementSignEventDtoList = new ArrayList();
            agreementList.forEach(item -> {
                AgreementSignEventDto agreementSignEventDto = new AgreementSignEventDto();
                agreementSignEventDto.setTemplateCode(dto.getTemplateCode());
                agreementSignEventDto.setAgreementId(item.getId());
                agreementSignEventDto.setSignTotalNum(dto.getSignTotalNum());
                agreementSignEventDtoList.add(agreementSignEventDto);
            });
            this.agreementSignNumSaveObservers.get(0).onSuccess(agreementSignEventDtoList);
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{profitAgreementTemplate = this.profitAgreementTemplateRepository.findByTemplateCode(dto.getTemplateCode())})) {
            Integer generatedAgreementNumber = profitAgreementTemplate.getGeneratedAgreementNumber();
            generatedAgreementNumber = Objects.isNull(generatedAgreementNumber) ? agreementList.size() : generatedAgreementNumber + agreementList.size();
            profitAgreementTemplate.setGeneratedAgreementNumber(generatedAgreementNumber);
            this.profitAgreementTemplateRepository.updateById((Object)profitAgreementTemplate);
        }
        return agreementList;
    }

    private void notifyEvent(Agreement agreement) {
        if (CollectionUtils.isEmpty(this.agreementSignObservers)) {
            return;
        }
        if (Objects.isNull((Object)agreement)) {
            return;
        }
        AgreementSignEventDto agreementSignEventDto = (AgreementSignEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreement, AgreementSignEventDto.class, null, null, new String[0]);
        for (AgreementSignObserver agreementSignObserver : this.agreementSignObservers) {
            agreementSignObserver.onSuccess(agreementSignEventDto);
        }
    }

    private Agreement createForm(AgreementSignDto dto, LoginUserDetails loginUser) {
        this.findByTemplateCodeAndTerminalCode(dto.getTemplateCode(), loginUser.getConsumerCode());
        ProfitAgreementTemplate template = this.profitAgreementTemplateRepository.findByTemplateCode(dto.getTemplateCode());
        Validate.notNull((Object)((Object)template), (String)"\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        Date date = new Date();
        Validate.isTrue((date.after(template.getSignStartTime()) && date.before(template.getSignEndTime()) ? 1 : 0) != 0, (String)"\u4e0d\u5728\u89c4\u5b9a\u7684\u7b7e\u7f72\u65f6\u95f4\u8303\u56f4\u5185\uff01", (Object[])new Object[0]);
        TerminalVo terminalVo = this.findTerminalByTerminalCode(loginUser.getConsumerCode(), template.getTemplateName());
        if (StringUtils.isBlank((CharSequence)dto.getCustomerCode())) {
            ArrayList supplyRelationshipVos = new ArrayList(terminalVo.getSupplyRelationships());
            Validate.notNull(supplyRelationshipVos, (String)"\u5f53\u524d\u4f9b\u8d27\u5173\u7cfb\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            dto.setCustomerCode(((SupplyRelationshipVo)supplyRelationshipVos.get(0)).getExternalIdentifier());
        }
        DealerVo dealerVo = this.dealerVoService.findByCustomerCode(dto.getCustomerCode());
        Validate.notNull((Object)dealerVo, (String)"\u5f53\u524d\u7ec8\u7aef\u6240\u5c5e\u7ecf\u9500\u5546\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Agreement agreement = new Agreement();
        agreement.setAgreementCode((String)this.generateCodeService.generateCode("agreement", 1).get(0));
        agreement.setAgreementName(StringUtils.joinWith((String)"-", (Object[])new Object[]{template.getTemplateName(), terminalVo.getTerminalName()}));
        agreement.setTemplateCode(dto.getTemplateCode());
        agreement.setBelongTemplate(template.getTemplateName());
        agreement.setTerminalCode(terminalVo.getTerminalCode());
        agreement.setRelationTerminal(terminalVo.getTerminalName());
        agreement.setCustomerCode(dealerVo.getCustomerCode());
        agreement.setRelationDealer(dealerVo.getCustomerName());
        agreement.setTerminalSignStatus(SignStatusEnum.SIGNED.getCode());
        agreement.setDealerSignStatus(SignStatusEnum.SIGNED.getCode());
        agreement.setTenantCode(TenantUtils.getTenantCode());
        agreement.setCreateTime(date);
        agreement.setCreateAccount(this.loginUserService.getLoginAccountName());
        agreement.setModifyTime(date);
        agreement.setModifyAccount(this.loginUserService.getLoginAccountName());
        if (AutoSignEnum.YES.getCode().equals(template.getAutoSign())) {
            agreement.setSignStatus(SignStatusEnum.SIGNED.getCode());
        } else {
            agreement.setSignStatus(SignStatusEnum.SIGNING.getCode());
        }
        if (date.before(template.getEffectiveStartTime())) {
            agreement.setAgreementStatus(AgreementStatusEnum.NOT_STARTED.getCode());
        } else if (date.after(template.getEffectiveStartTime()) && date.before(template.getEffectiveEndTime())) {
            agreement.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        } else {
            agreement.setAgreementStatus(AgreementStatusEnum.COMPLETED.getCode());
        }
        return agreement;
    }

    private List<Agreement> createFormBatch(AgreementSignDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getTerminalList())) {
            return new ArrayList<Agreement>();
        }
        ArrayList<Agreement> agreementList = new ArrayList<Agreement>();
        dto.getTerminalList().forEach(item -> {
            this.findByTemplateCodeAndTerminalCode(dto.getTemplateCode(), item.getTerminalCode());
            ProfitAgreementTemplate template = this.profitAgreementTemplateRepository.findByTemplateCode(dto.getTemplateCode());
            Validate.notNull((Object)((Object)template), (String)"\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
            Date date = new Date();
            Validate.isTrue((date.after(template.getSignStartTime()) && date.before(template.getSignEndTime()) ? 1 : 0) != 0, (String)"\u4e0d\u5728\u89c4\u5b9a\u7684\u7b7e\u7f72\u65f6\u95f4\u8303\u56f4\u5185\uff01", (Object[])new Object[0]);
            Agreement agreement = new Agreement();
            agreement.setAgreementCode((String)this.generateCodeService.generateCode("agreement", 1).get(0));
            agreement.setAgreementName(StringUtils.joinWith((String)"-", (Object[])new Object[]{template.getTemplateName(), item.getTerminalName()}));
            agreement.setTemplateCode(dto.getTemplateCode());
            agreement.setSignTotalNum(dto.getSignTotalNum());
            agreement.setBelongTemplate(template.getTemplateName());
            agreement.setTerminalCode(item.getTerminalCode());
            agreement.setRelationTerminal(item.getTerminalName());
            agreement.setCustomerCode(dto.getCustomerCode());
            agreement.setRelationDealer(dto.getCustomerName());
            agreement.setTerminalSignStatus(SignStatusEnum.SIGNED.getCode());
            agreement.setDealerSignStatus(SignStatusEnum.SIGNED.getCode());
            agreement.setTenantCode(TenantUtils.getTenantCode());
            agreement.setCreateTime(date);
            agreement.setCreateAccount(this.loginUserService.getLoginAccountName());
            agreement.setModifyTime(date);
            agreement.setModifyAccount(this.loginUserService.getLoginAccountName());
            agreement.setSignStatus(SignStatusEnum.SIGN.getCode());
            agreement.setAgreementStatus(AgreementStatusEnum.NOT_STARTED.getCode());
            agreementList.add(agreement);
        });
        return agreementList;
    }

    @Override
    public Agreement findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u6b64\u64cd\u4f5c\u65f6\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return (Agreement)((Object)this.agreementRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public Agreement findDetailsById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u6b64\u64cd\u4f5c\u65f6\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Agreement agreement = this.agreementRepository.findDetailsById(id);
        return agreement;
    }

    @Override
    public Page<Agreement> findByConditions(Pageable pageable, AgreementDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AgreementDto();
        }
        return this.agreementRepository.findByConditions(pageable, dto);
    }

    @Override
    public List<Agreement> findByCurrentTime(Date date) {
        if (Objects.isNull(date)) {
            date = new Date();
        }
        return this.agreementRepository.findByCurrentTime(date);
    }

    @Override
    @Transactional
    public void createOrUpdateBatch(List<Agreement> list) {
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u6279\u91cf\u64cd\u4f5c\u65f6\uff0c\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.agreementRepository.saveOrUpdateBatch(list);
    }

    @Override
    public List<Agreement> findByTemplateCodes(List<String> templateCodes) {
        if (CollectionUtils.isEmpty(templateCodes)) {
            return null;
        }
        return this.agreementRepository.findByTemplateCodes(templateCodes);
    }

    @Override
    public Boolean waitSignAgreementFlag(String terminalCode) {
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            LoginUserDetails loginUser = this.loginUserService.getLoginUser();
            Validate.notNull((Object)loginUser, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
            terminalCode = loginUser.getConsumerCode();
        }
        Validate.notBlank((CharSequence)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"terminal_code", (Object)terminalCode);
        queryWrapper.eq((Object)"sign_status", (Object)SignStatusEnum.SIGN.getCode());
        Integer count = ((AgreementMapper)this.agreementRepository.getBaseMapper()).selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public void signAgreement(AgreementSignDto dto) {
        Validate.notBlank((CharSequence)dto.getAgreementId(), (String)"\u534f\u8baeid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((SignStatusEnum.REJECT.getCode().equals(dto.getSignStatus()) || SignStatusEnum.SIGNED.getCode().equals(dto.getSignStatus()) ? 1 : 0) != 0, (String)"\u7b7e\u7f72\u72b6\u6001\u53ea\u80fd\u4e3a\u5df2\u7b7e\u7f72\u548c\u62d2\u7b7e\uff01", (Object[])new Object[0]);
        if (SignStatusEnum.SIGNED.getCode().equals(dto.getSignStatus())) {
            Validate.notBlank((CharSequence)dto.getSignaturePath(), (String)"\u7b7e\u7f72\u534f\u8bae\u65f6\uff0c\u7b7e\u540d\u7167\u7247\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getSignatureFilename(), (String)"\u7b7e\u7f72\u534f\u8bae\u65f6\uff0c\u7b7e\u540d\u7167\u7247\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Agreement agreement = (Agreement)((Object)this.agreementRepository.getById((Serializable)((Object)dto.getAgreementId())));
        Validate.notNull((Object)((Object)agreement), (String)("id\uff1a" + dto.getAgreementId() + "\u534f\u8bae\u4e0d\u5b58\u5728\uff01"), (Object[])new Object[0]);
        boolean statusConfirm = SignStatusEnum.SIGN.getCode().equals(agreement.getSignStatus()) || SignStatusEnum.REJECT.getCode().equals(agreement.getSignStatus());
        Validate.isTrue((boolean)statusConfirm, (String)"\u8be5\u534f\u8bae\u5df2\u7b7e\u7f72\u901a\u8fc7\uff0c\u4e0d\u80fd\u591a\u6b21\u7b7e\u7f72\uff01", (Object[])new Object[0]);
        Date date = new Date();
        ProfitAgreementTemplate template = this.profitAgreementTemplateRepository.findByTemplateCode(agreement.getTemplateCode());
        Validate.notNull((Object)((Object)template), (String)"\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        if (SignStatusEnum.REJECT.getCode().equals(dto.getSignStatus())) {
            agreement.setSignStatus(SignStatusEnum.REJECT.getCode());
            agreement.setAgreementStatus(AgreementStatusEnum.COMPLETED.getCode());
        }
        if (SignStatusEnum.SIGNED.getCode().equals(dto.getSignStatus())) {
            agreement.setSignStatus(SignStatusEnum.SIGNED.getCode());
            agreement.setSignatureFilename(dto.getSignatureFilename());
            agreement.setSignaturePath(dto.getSignaturePath());
            if (date.before(template.getEffectiveStartTime())) {
                agreement.setAgreementStatus(AgreementStatusEnum.NOT_STARTED.getCode());
            } else if (date.after(template.getEffectiveStartTime()) && date.before(template.getEffectiveEndTime())) {
                agreement.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
            } else {
                agreement.setAgreementStatus(AgreementStatusEnum.COMPLETED.getCode());
            }
        }
        agreement.setSignTime(date);
        this.agreementRepository.updateById((Object)agreement);
        if (SignStatusEnum.SIGNED.getCode().equals(agreement.getSignStatus())) {
            this.notifyEvent(agreement);
        }
    }

    @Override
    public List<ScanCodeAgreementDto> findTerminalAgreementScanCodeInfo(String terminalCode) {
        return this.agreementRepository.findTerminalAgreementScanCodeInfo(terminalCode);
    }

    @Override
    public List<ScanCodeAgreementDto> findTerminalScanCodeRewardInfo(String terminalCode) {
        return this.agreementRepository.findTerminalScanCodeRewardInfo(terminalCode);
    }

    @Override
    @Transactional
    public void revoke(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u6b64\u64cd\u4f5c\u65f6\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AgreementDto agreementDto = new AgreementDto();
        agreementDto.setIds(ids);
        List<Agreement> agreements = this.agreementRepository.findByConditions(agreementDto);
        Validate.isTrue((!CollectionUtils.isEmpty(agreements) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u9700\u8981\u64a4\u9500\u7ec8\u6b62\u7684\u534f\u8bae\uff01", (Object[])new Object[0]);
        List newAgreements = agreements.stream().filter(agreement -> AgreementStatusEnum.TERMINATED.getCode().equals(agreement.getAgreementStatus()) && !Objects.isNull((Object)agreement.getProfitAgreementTemplate()) && EnableStatusEnum.ENABLE.getCode().equals(agreement.getProfitAgreementTemplate().getEnableStatus())).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(newAgreements) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u9700\u8981\u64a4\u9500\u7ec8\u6b62\u7684\u534f\u8bae\uff01", (Object[])new Object[0]);
        Date date = new Date();
        newAgreements.stream().forEach(agreement -> {
            ProfitAgreementTemplate template = agreement.getProfitAgreementTemplate();
            Date startTime = template.getEffectiveStartTime();
            Date endTime = template.getEffectiveEndTime();
            if (date.before(startTime)) {
                agreement.setAgreementStatus(AgreementStatusEnum.NOT_STARTED.getCode());
            } else if (date.after(startTime) && date.before(endTime)) {
                agreement.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
            } else {
                agreement.setAgreementStatus(AgreementStatusEnum.COMPLETED.getCode());
            }
        });
        this.agreementRepository.saveOrUpdateBatch(newAgreements);
    }

    private void createValidation(AgreementSignDto dto) {
        Validate.notNull((Object)dto, (String)"\u7b7e\u7f72\u64cd\u4f5c\u65f6\uff0c\u7b7e\u7f72\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTemplateCode(), (String)"\u7b7e\u7f72\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSignaturePath(), (String)"\u7b7e\u7f72\u64cd\u4f5c\u65f6\uff0c\u7b7e\u540d\u7167\u7247\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSignatureFilename(), (String)"\u7b7e\u7f72\u64cd\u4f5c\u65f6\uff0c\u7b7e\u540d\u7167\u7247\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void createValidationBatch(AgreementSignDto dto) {
        Validate.notNull((Object)dto, (String)"\u751f\u6210\u534f\u8bae\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTemplateCode(), (String)"\u751f\u6210\u534f\u8bae\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u751f\u6210\u534f\u8bae\u65f6\uff0c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerName(), (String)"\u751f\u6210\u534f\u8bae\u65f6\uff0c\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getTerminalList(), (String)"\u751f\u6210\u534f\u8bae\u65f6\uff0c\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.getTerminalList().forEach(item -> {
            Validate.notBlank((CharSequence)item.getTerminalCode(), (String)"\u751f\u6210\u534f\u8bae\u65f6\uff0c\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getTerminalName(), (String)"\u751f\u6210\u534f\u8bae\u65f6\uff0c\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
        if (!CollectionUtils.isEmpty((Collection)dto.getQuantifyRangeList())) {
            BigDecimal signTotalNum = BigDecimal.valueOf(0L);
            for (QuantifyRangeDto item2 : dto.getQuantifyRangeList()) {
                Validate.notBlank((CharSequence)item2.getSpecialCode(), (String)"\u751f\u6210\u534f\u8bae\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)item2.getSpecialName(), (String)"\u751f\u6210\u534f\u8bae\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notNull((Object)item2.getSignNum(), (String)"\u751f\u6210\u534f\u8bae\u65f6\uff0c\u603b\u9500\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                signTotalNum = signTotalNum.add(item2.getSignNum());
            }
            dto.setSignTotalNum(signTotalNum);
        }
        if (!CollectionUtils.isEmpty(this.agreementSignNumConfirmObservers) && dto.getSignTotalNum() != null) {
            Validate.isTrue((boolean)this.agreementSignNumConfirmObservers.get(0).onSuccess(dto), (String)"\u751f\u6210\u534f\u8bae\u65f6\uff0c\u7b7e\u7f72\u7684\u5305\u91cf\u76ee\u6807\u8d85\u51fa\u8303\u56f4\uff01", (Object[])new Object[0]);
        }
    }

    private List<AgreementSign> createAgreementSignForm(AgreementSignDto dto, LoginUserDetails loginUser, Agreement agreement) {
        ArrayList<AgreementSign> signList = new ArrayList<AgreementSign>();
        AgreementSign dealerAgreementSign = new AgreementSign();
        dealerAgreementSign.setAgreementCode(agreement.getAgreementCode());
        dealerAgreementSign.setSignatory(SignatoryEnum.DEALER.getDictCode());
        dealerAgreementSign.setSignatoryCode(agreement.getCustomerCode());
        dealerAgreementSign.setSignatoryName(agreement.getRelationDealer());
        dealerAgreementSign.setSignDate(new Date());
        dealerAgreementSign.setSignAccount(agreement.getRelationDealer());
        dealerAgreementSign.setTenantCode(TenantUtils.getTenantCode());
        AgreementSign terminalAgreementSign = (AgreementSign)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dealerAgreementSign, AgreementSign.class, null, null, new String[0]));
        terminalAgreementSign.setSignatureFilename(dto.getSignatureFilename());
        terminalAgreementSign.setSignaturePath(dto.getSignaturePath());
        terminalAgreementSign.setSignatory(SignatoryEnum.TERMINAL.getDictCode());
        terminalAgreementSign.setSignatoryCode(agreement.getTerminalCode());
        terminalAgreementSign.setSignatoryName(agreement.getRelationTerminal());
        terminalAgreementSign.setSignAccount(agreement.getRelationTerminal());
        AgreementSign agreementSign = (AgreementSign)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dealerAgreementSign, AgreementSign.class, null, null, new String[0]));
        agreementSign.setSignatory(SignatoryEnum.BRAND.getDictCode());
        agreementSign.setSignatoryCode(TenantUtils.getTenantCode());
        agreementSign.setSignatoryName(TenantUtils.getTenantCode());
        agreementSign.setSignAccount(TenantUtils.getTenantCode());
        signList.add(dealerAgreementSign);
        signList.add(terminalAgreementSign);
        if (SignStatusEnum.SIGNED.getCode().equals(agreement.getSignStatus())) {
            signList.add(agreementSign);
        }
        return signList;
    }

    private void findByTemplateCodeAndTerminalCode(String templateCode, String terminalCode) {
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        ArrayList<String> templateCodes = new ArrayList<String>();
        templateCodes.add(templateCode);
        loginUserAgreementDto.setTemplateCodes(templateCodes);
        loginUserAgreementDto.setTerminalCode(terminalCode);
        List<Agreement> byConditions = this.agreementRepository.findByConditions(loginUserAgreementDto);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(byConditions), (String)"\u5df2\u7b7e\u7f72\u5f53\u524d\u534f\u8bae\uff01", (Object[])new Object[0]);
    }

    private TerminalVo findTerminalByTerminalCode(String terminalCode, String templateName) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(terminalCode);
        List terminalVoList = this.terminalVoService.findByTerminalCodes(list);
        Validate.notNull((Object)terminalVoList, (String)"\u5f53\u524d\u7ec8\u7aef\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        TerminalVo terminalVo = (TerminalVo)terminalVoList.get(0);
        return terminalVo;
    }
}

