/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.repository.AgreementRepository;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgreementVoServiceImpl
implements AgreementVoService {
    private static final Logger log = LoggerFactory.getLogger(AgreementVoServiceImpl.class);
    @Resource
    private AgreementRepository agreementRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public List<AgreementVo> findByConditions(LoginUserAgreementDto dto) {
        List<Agreement> agreements;
        if (dto == null) {
            dto = new LoginUserAgreementDto();
        }
        if (CollectionUtils.isEmpty(agreements = this.agreementRepository.findByConditions(dto))) {
            return null;
        }
        ArrayList<AgreementVo> agreementVos = new ArrayList<AgreementVo>();
        agreements.stream().forEach(agreement -> {
            AgreementVo agreementVo = this.buildAgreementVo((Agreement)((Object)agreement));
            agreementVos.add(agreementVo);
        });
        return agreementVos;
    }

    public Page<AgreementVo> findByConditions(Pageable pageable, AgreementDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new AgreementDto();
        }
        Page<Agreement> byConditions = this.agreementRepository.findByConditions(pageable, dto);
        ArrayList agreementVos = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)byConditions.getRecords())) {
            byConditions.getRecords().stream().forEach(agreement -> {
                AgreementVo agreementVo = this.buildAgreementVo((Agreement)((Object)agreement));
                agreementVos.add(agreementVo);
            });
        }
        Page agreementVoPage = new Page();
        agreementVoPage.setCurrent(byConditions.getCurrent());
        agreementVoPage.setSize(byConditions.getSize());
        agreementVoPage.setTotal(byConditions.getTotal());
        agreementVoPage.setRecords(agreementVos);
        return agreementVoPage;
    }

    public AgreementVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Agreement agreement = this.agreementRepository.findDetailsById(id);
        if (Objects.isNull((Object)agreement)) {
            return null;
        }
        AgreementVo agreementVo = (AgreementVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreement, AgreementVo.class, null, null, new String[0]);
        if (Objects.isNull((Object)agreement.getProfitAgreementTemplate())) {
            return null;
        }
        agreementVo.setAgreementText(agreement.getProfitAgreementTemplate().getAgreementText());
        return agreementVo;
    }

    public AgreementVo findByAgreementCode(String agreementCode) {
        if (StringUtils.isEmpty((CharSequence)agreementCode)) {
            return null;
        }
        Agreement agreement = this.agreementRepository.findByAgreementCode(agreementCode);
        if (Objects.isNull((Object)agreement)) {
            return null;
        }
        return this.buildAgreementVo(agreement);
    }

    public Boolean findExistByCurrentUser() {
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff1a" + loginUser);
        if (Objects.isNull(loginUser)) {
            return false;
        }
        String usertype = loginUser.getUsertype();
        String consumerCode = loginUser.getConsumerCode();
        LoginUserAgreementDto dto = new LoginUserAgreementDto();
        if (ParticipatorTypeEnum.DEALER.getKey().equals(usertype)) {
            dto.setCustomerCode(consumerCode);
        } else if (ParticipatorTypeEnum.TERMINAL.getKey().equals(usertype)) {
            dto.setTerminalCode(consumerCode);
        } else {
            return false;
        }
        dto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        dto.setSignStatus(SignStatusEnum.SIGNED.getCode());
        List<Agreement> agreements = this.agreementRepository.findByConditions(dto);
        if (CollectionUtils.isEmpty(agreements)) {
            return false;
        }
        return true;
    }

    public List<AgreementVo> findAgreementVoList(LoginUserAgreementDto dto) {
        if (dto == null) {
            dto = new LoginUserAgreementDto();
        }
        return this.agreementRepository.findAgreementVoList(dto);
    }

    private AgreementVo buildAgreementVo(Agreement agreement) {
        if (Objects.isNull((Object)agreement)) {
            return null;
        }
        AgreementVo agreementVo = (AgreementVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreement, AgreementVo.class, null, null, new String[0]);
        ProfitAgreementTemplate profitAgreementTemplate = agreement.getProfitAgreementTemplate();
        if (profitAgreementTemplate != null) {
            agreementVo.setEffectiveStartTime(profitAgreementTemplate.getEffectiveStartTime());
            agreementVo.setEffectiveEndTime(profitAgreementTemplate.getEffectiveEndTime());
            agreementVo.setSignStartTime(profitAgreementTemplate.getSignStartTime());
            agreementVo.setSignEndTime(profitAgreementTemplate.getSignEndTime());
        }
        return agreementVo;
    }
}

