/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.mapper.AgreementMapper;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AgreementRepository
extends ServiceImpl<AgreementMapper, Agreement> {
    @Resource
    private AgreementMapper agreementMapper;

    public Page<Agreement> findByConditions(Pageable pageable, AgreementDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Agreement> agreementPage = this.agreementMapper.findByConditions((Page<Agreement>)page, dto);
        return agreementPage;
    }

    public void updateSignStatusByIds(SignStatusEnum signStatusEnum, List<String> ids) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"sign_status", (Object)signStatusEnum.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public void updateAgreementStatusByIds(AgreementStatusEnum agreementStatusEnum, List<String> ids) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"agreement_status", (Object)agreementStatusEnum.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public Agreement findDetailsById(String id) {
        return this.agreementMapper.findDetailsById(id);
    }

    public void updateDealerSignStatusById(SignStatusEnum signStatusEnum, String agreementCode) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"dealer_sign_status", (Object)signStatusEnum.getCode());
        updateWrapper.eq((Object)"agreement_code", (Object)agreementCode);
        this.update((Wrapper)updateWrapper);
    }

    public List<Agreement> findByIds(List<String> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", ids);
        return this.list((Wrapper)queryWrapper);
    }

    public List<Agreement> findByConditions(LoginUserAgreementDto dto) {
        List<Agreement> agreements = this.agreementMapper.findByLoginUserAgreementDto(dto);
        return agreements;
    }

    public List<Agreement> findByTerminalCode(String terminalCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"terminal_code", (Object)terminalCode);
        return this.list((Wrapper)queryWrapper);
    }

    public Agreement findByAgreementCode(String agreementCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"agreement_code", (Object)agreementCode);
        return (Agreement)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public List<Agreement> findByCurrentTime(Date date) {
        return this.agreementMapper.findByCurrentTime(date);
    }

    public List<Agreement> findByTemplateCodes(List<String> templateCodes) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"template_code", templateCodes);
        return this.list((Wrapper)queryWrapper);
    }

    public List<Agreement> findByDealerCode(String enableStatus, String customerCode) {
        return this.agreementMapper.findByDealerCode(enableStatus, customerCode);
    }
}

