/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.internal;

import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.entity.AgreementSign;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.repository.AgreementRepository;
import com.biz.crm.cps.business.agreement.local.repository.AgreementSignRepository;
import com.biz.crm.cps.business.agreement.local.repository.ProfitAgreementTemplateRepository;
import com.biz.crm.cps.business.agreement.local.service.AgreementSignService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AutoSignEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignatoryEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.sdk.dto.NoNormalDealerEventDto;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AgreementSignServiceImpl
implements AgreementSignService {
    @Resource
    private AgreementSignRepository agreementSignRepository;
    @Autowired
    private ProfitAgreementTemplateRepository profitAgreementTemplateRepository;
    @Resource
    private AgreementRepository agreementRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DealerVoService dealerVoService;

    @Override
    @Transactional
    public AgreementSign create(AgreementSign agreementSign) {
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        Validate.notNull((Object)loginUser, (String)"\u672a\u67e5\u8be2\u5230\u767b\u5f55\u4fe1\u606f\uff01", (Object[])new Object[0]);
        this.createValidation(agreementSign);
        this.agreementRepository.updateDealerSignStatusById(SignStatusEnum.SIGNED, agreementSign.getAgreementCode());
        agreementSign.setSignatory(SignatoryEnum.DEALER.getDictCode());
        agreementSign.setSignDate(new Date());
        agreementSign.setTenantCode(TenantUtils.getTenantCode());
        agreementSign.setSignatoryName(this.loginUserService.getLoginAccountName());
        agreementSign.setSignatoryCode(loginUser.getUsername());
        agreementSign.setSignAccount(this.loginUserService.getLoginAccountName());
        this.agreementSignRepository.saveOrUpdate((Object)agreementSign);
        return agreementSign;
    }

    private void createValidation(AgreementSign agreementSign) {
        Validate.notNull((Object)((Object)agreementSign), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)agreementSign.getAgreementCode(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u534f\u8bae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)agreementSign.getSignatureFilename(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u7b7e\u540d\u7167\u7247\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)agreementSign.getSignaturePath(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u7b7e\u540d\u7167\u7247\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((agreementSign.getAgreementCode() == null || agreementSign.getAgreementCode().length() < 128 ? 1 : 0) != 0, (String)"\u534f\u8bae\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((agreementSign.getSignatureFilename() == null || agreementSign.getSignatureFilename().length() < 255 ? 1 : 0) != 0, (String)"\u534f\u8bae\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((agreementSign.getSignaturePath() == null || agreementSign.getSignaturePath().length() < 255 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u534f\u8bae\u6a21\u677f\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public void dealerSign(String templateCode, List<String> dealers) {
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        Validate.notNull((Object)loginUser, (String)"\u672a\u67e5\u8be2\u5230\u767b\u5f55\u4fe1\u606f\uff01", (Object[])new Object[0]);
        ProfitAgreementTemplate profitAgreementTemplate = this.profitAgreementTemplateRepository.findByTemplateCode(templateCode);
        ArrayList dealerList = new ArrayList();
        dealers.forEach(type -> {
            List dealerVos = this.dealerVoService.findByTypeCode(type);
            if (!CollectionUtils.isEmpty((Collection)dealerVos)) {
                dealerList.addAll(dealerVos);
            }
        });
        ArrayList agreements = new ArrayList();
        ArrayList agreementSigns = new ArrayList();
        if (!CollectionUtils.isEmpty(dealerList)) {
            dealerList.forEach(dealerVo -> {
                Agreement agreement = this.createAgreementForm(profitAgreementTemplate, (DealerVo)dealerVo);
                agreements.add(agreement);
                List<AgreementSign> agreementSign = this.createAgreementSignForm(agreement, loginUser);
                agreementSigns.addAll(agreementSign);
            });
            this.agreementRepository.saveBatch(agreements);
            this.agreementSignRepository.saveBatch(agreementSigns);
            Integer generatedAgreementNumber = profitAgreementTemplate.getGeneratedAgreementNumber();
            generatedAgreementNumber = Objects.isNull(generatedAgreementNumber) ? 0 : generatedAgreementNumber;
            generatedAgreementNumber = generatedAgreementNumber + dealers.size();
            profitAgreementTemplate.setGeneratedAgreementNumber(generatedAgreementNumber);
            this.profitAgreementTemplateRepository.updateById((Object)profitAgreementTemplate);
        }
    }

    @Override
    public void signByDealer(List<ProfitAgreementTemplate> templates, NoNormalDealerEventDto dealer) {
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        Validate.notNull((Object)loginUser, (String)"\u672a\u67e5\u8be2\u5230\u767b\u5f55\u4fe1\u606f\uff01", (Object[])new Object[0]);
        templates.forEach(profitAgreementTemplate -> {
            DealerVo dealerVo = (DealerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dealer, DealerVo.class, null, null, new String[0]);
            Agreement agreement = this.createAgreementForm((ProfitAgreementTemplate)((Object)profitAgreementTemplate), dealerVo);
            List<AgreementSign> agreementSign = this.createAgreementSignForm(agreement, loginUser);
            this.agreementRepository.save((Object)agreement);
            this.agreementSignRepository.saveBatch(agreementSign);
            Integer generatedAgreementNumber = profitAgreementTemplate.getGeneratedAgreementNumber();
            generatedAgreementNumber = Objects.isNull(generatedAgreementNumber) ? 0 : generatedAgreementNumber;
            generatedAgreementNumber = generatedAgreementNumber + 1;
            profitAgreementTemplate.setGeneratedAgreementNumber(generatedAgreementNumber);
            this.profitAgreementTemplateRepository.updateById(profitAgreementTemplate);
        });
    }

    private List<AgreementSign> createAgreementSignForm(Agreement agreement, LoginUserDetails loginUser) {
        ArrayList<AgreementSign> signList = new ArrayList<AgreementSign>();
        AgreementSign dealerAgreementSign = new AgreementSign();
        dealerAgreementSign.setAgreementCode(agreement.getAgreementCode());
        dealerAgreementSign.setSignatory(SignatoryEnum.DEALER.getDictCode());
        dealerAgreementSign.setSignatoryCode(agreement.getCustomerCode());
        dealerAgreementSign.setSignatoryName(agreement.getRelationDealer());
        dealerAgreementSign.setSignDate(new Date());
        dealerAgreementSign.setSignAccount(agreement.getRelationDealer());
        dealerAgreementSign.setTenantCode(TenantUtils.getTenantCode());
        AgreementSign agreementSign = (AgreementSign)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dealerAgreementSign, AgreementSign.class, null, null, new String[0]));
        agreementSign.setSignatory(SignatoryEnum.BRAND.getDictCode());
        agreementSign.setSignatoryCode(loginUser.getConsumerCode());
        agreementSign.setSignatoryName(this.loginUserService.getLoginAccountName());
        agreementSign.setSignAccount(this.loginUserService.getLoginAccountName());
        signList.add(dealerAgreementSign);
        if (SignStatusEnum.SIGNED.getCode().equals(agreement.getSignStatus())) {
            signList.add(agreementSign);
        }
        return signList;
    }

    private Agreement createAgreementForm(ProfitAgreementTemplate profitAgreementTemplate, DealerVo dealerVo) {
        Date date = new Date();
        Agreement agreement = new Agreement();
        agreement.setAgreementCode((String)this.generateCodeService.generateCode("agreement", 1).get(0));
        agreement.setAgreementName(StringUtils.joinWith((String)"-", (Object[])new Object[]{profitAgreementTemplate.getTemplateName(), dealerVo.getCustomerName()}));
        agreement.setTemplateCode(profitAgreementTemplate.getTemplateCode());
        agreement.setBelongTemplate(profitAgreementTemplate.getTemplateName());
        agreement.setCustomerCode(dealerVo.getCustomerCode());
        agreement.setRelationDealer(dealerVo.getCustomerName());
        agreement.setDealerSignStatus(SignStatusEnum.SIGNED.getCode());
        agreement.setTenantCode(TenantUtils.getTenantCode());
        agreement.setCreateTime(date);
        agreement.setCreateAccount(this.loginUserService.getLoginAccountName());
        agreement.setModifyTime(date);
        agreement.setModifyAccount(this.loginUserService.getLoginAccountName());
        if (AutoSignEnum.YES.getCode().equals(profitAgreementTemplate.getAutoSign())) {
            agreement.setSignStatus(SignStatusEnum.SIGNED.getCode());
        } else {
            agreement.setSignStatus(SignStatusEnum.SIGNING.getCode());
        }
        if (date.before(profitAgreementTemplate.getEffectiveStartTime())) {
            agreement.setAgreementStatus(AgreementStatusEnum.NOT_STARTED.getCode());
        } else if (date.after(profitAgreementTemplate.getEffectiveStartTime()) && date.before(profitAgreementTemplate.getEffectiveEndTime())) {
            agreement.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        } else {
            agreement.setAgreementStatus(AgreementStatusEnum.COMPLETED.getCode());
        }
        return agreement;
    }
}

