package com.biz.crm.cps.business.agreement.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author songjingen
 * @Description:签署方
 **/
public enum AgreementLadderTypeEnum {
  /**
   * 编码与描述
   */
  QUANTIFY("quantify", "quantify", "包量阶梯", "1"),
  DISPLAY("display", "display", "陈列阶梯", "2");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  AgreementLadderTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  public String getDictCode() {
    return dictCode;
  }

  /**
   * 通过key获取 SignatoryEnum
   *
   * @param key
   * @return
   */
  public static AgreementLadderTypeEnum getByKey(String key) {
    return Arrays.stream(AgreementLadderTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 SignatoryEnum
   *
   * @param value
   * @return
   */
  public static AgreementLadderTypeEnum getByValue(String value) {
    return Arrays.stream(AgreementLadderTypeEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
            .findFirst().orElse(null);
  }

}

