package com.biz.crm.cps.business.agreement.sdk.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:协议状态
 * @author songjingen
 **/
public enum AgreementStatusEnum {
  /**
   * 编码与描述
   */
  NOT_STARTED("0", "未开始"),
  EXECUTING("1", "进行中"),
  COMPLETED("2", "已结束"),
  TERMINATED("3", "已终止");

  private String code;
  private String des;

  AgreementStatusEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   * @return
   */
  public static Set<String> codeToSet(){
    Set<String> codes = new HashSet<>();
    for (AgreementStatusEnum enableStatusEnum : AgreementStatusEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      AgreementStatusEnum[] values = AgreementStatusEnum.values();
      for (AgreementStatusEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }


  /**
   * 判断枚举中是否包含该code
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    AgreementStatusEnum[] values = AgreementStatusEnum.values();
    for (AgreementStatusEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

