package com.biz.crm.cps.business.agreement.sdk.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:自动签署状态
 * @author songjingen
 **/
public enum AutoSignEnum {
  /**
   * 编码与描述
   */
  YES("Y", "是"),
  NO("N", "否");

  private String code;
  private String des;

  AutoSignEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   * @return
   */
  public static Set<String> codeToSet(){
    Set<String> codes = new HashSet<>();
    for (AutoSignEnum enableStatusEnum : AutoSignEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      AutoSignEnum[] values = AutoSignEnum.values();
      for (AutoSignEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }


  /**
   * 判断枚举中是否包含该code
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    AutoSignEnum[] values = AutoSignEnum.values();
    for (AutoSignEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

