package com.biz.crm.cps.business.agreement.sdk.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:签署状态
 * @author songjingen
 **/
public enum SignStatusEnum {
  /**
   * 编码与描述
   */
  SIGN("0", "待签署"),
  SIGNING("1", "签署中"),
  SIGNED("2", "已签署");

  private String code;
  private String des;

  SignStatusEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   * @return
   */
  public static Set<String> codeToSet(){
    Set<String> codes = new HashSet<>();
    for (SignStatusEnum enableStatusEnum : SignStatusEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      SignStatusEnum[] values = SignStatusEnum.values();
      for (SignStatusEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }


  /**
   * 判断枚举中是否包含该code
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    SignStatusEnum[] values = SignStatusEnum.values();
    for (SignStatusEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

