package com.biz.crm.cps.business.agreement.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description:签署方
 * @author songjingen
 **/
public enum SignatoryEnum {
  /**
   * 编码与描述
   */
  BRAND("brand", "0", "品牌方", "1"),
  DEALER("dealer", "1", "经销商", "2"),
  TERMINAL("terminal", "2", "终端", "3");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  SignatoryEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  public String getDictCode() {
    return dictCode;
  }

  /**
   * 通过key获取 SignatoryEnum
   *
   * @param key
   * @return
   */
  public static SignatoryEnum getByKey(String key) {
    return Arrays.stream(SignatoryEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 SignatoryEnum
   *
   * @param value
   * @return
   */
  public static SignatoryEnum getByValue(String value) {
    return Arrays.stream(SignatoryEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
        .findFirst().orElse(null);
  }

}

