package com.biz.crm.cps.business.agreement.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 分利协议查询dto
 * @author songjingen
 */
@Data
@ApiModel(value = "AgreementDto", description = "分利协议查询dto")
public class AgreementDto implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = -3901176452532511387L;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  private String agreementCode;

  /**
   * 协议名称
   */
  @ApiModelProperty("协议名称")
  private String agreementName;

  /**
   * 关联终端
   */
  @ApiModelProperty("关联终端")
  private String relationTerminal;

  /**
   * 关联经销商
   */
  @ApiModelProperty("关联经销商")
  private String relationDealer;

  /**
   * 协议开始时间
   */
  @ApiModelProperty("协议开始时间")
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date effectiveStartTime;

  /**
   * 协议结束时间
   */
  @ApiModelProperty("协议结束时间")
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date effectiveEndTime;

  /**
   * 签署开始时间
   */
  @ApiModelProperty("签署开始时间")
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date signStartTime;

  /**
   * 签署结束时间
   */
  @ApiModelProperty("签署结束时间")
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date signEndTime;

  /**
   * 协议状态
   */
  @ApiModelProperty("协议状态")
  private String agreementStatus;

  /**
   * 签署状态
   */
  @ApiModelProperty("签署状态")
  private String signStatus;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 经销商编码
   */
  @ApiModelProperty("经销商编码")
  private String customerCode;

  /**
   * 终端签署状态
   */
  @ApiModelProperty("终端签署状态")
  private String terminalSignStatus;

  /**
   * 经销商签署状态
   */
  @ApiModelProperty("经销商签署状态")
  private String dealerSignStatus;

  /**
   * 模板集合
   */
  @ApiModelProperty("模板编码集合")
  private List<String> templateCodes;

  /**
   * id集合
   */
  @ApiModelProperty("id集合")
  private List<String> ids;

}
