package com.biz.crm.cps.business.agreement.sdk.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 所有协议政策跟协议模板交互时传参都应该继承该类
 * @author hefan
 */
@Data
public abstract class AgreementPolicyDto implements Serializable {
  private static final long serialVersionUID = 4563263770593299613L;
  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  private String templateCode;

  /**
   * 协议政策Key
   */
  @ApiModelProperty("协议政策Key")
  private String policyKey;

  /**
   * 奖励周期类型(1:自然年/2:财年)
   */
  @ApiModelProperty("奖励周期类型(1:自然年/2:财年) ")
  private String rewardCycleType;

  /**
   * 财年
   */
  @ApiModelProperty("财年")
  private String fiscal;
}
