package com.biz.crm.cps.business.agreement.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 登录用户协议查询dto
 * @author songjingen
 */
@Data
@ApiModel(value = "LoginUserAgreementDto", description = "登录用户协议查询dto")
public class LoginUserAgreementDto implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = -3901176452532511387L;


  /**
   * 协议状态 : 0-未开始，1-进行中，2-已结束，3-已终止
   * @see com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum
   */
  @ApiModelProperty("协议状态")
  private String agreementStatus;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 经销商编码
   */
  @ApiModelProperty("经销商编码")
  private String customerCode;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  private String agreementCode;

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  private List<String> templateCodes;

  /**
   * 品牌商签署状态
   * @see com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum
   */
  @ApiModelProperty("品牌商签署状态")
  private String signStatus;
}
