package com.biz.crm.cps.business.agreement.sdk.dto;

import com.biz.crm.cps.business.product.sdk.dto.MaterialDimensionDto;
import com.biz.crm.cps.business.product.sdk.dto.ProductDimensionDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 协议模块 传递到 协议政策模块组的dto
 * 协议政策模块组使用该dto可以获取到适配的奖励预先配置
 * @author hefan
 */
@Data
public class PolicyObserverDto implements Serializable {
  private static final long serialVersionUID = -2146625465980333550L;

  /**
   * 配置模板编码集合
    */
  @ApiModelProperty("配置模板编码集合")
  private Set<String> templateCodes;

  /**
   * 可以用来查询商品维度的商品唯一标识编号
    */
  @ApiModelProperty("可以用来查询商品维度的商品唯一标识编号")
  private String productCode;

  /**
   * 主体---干扫码这个事的人的分利参与者
    */
  @ApiModelProperty("主体---干扫码这个事的人的分利参与者")
  private String participatorCode;

  /**
   * 参与者类型：1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty("参与者类型：1-经销商，2-终端，3-消费者")
  private String participatorType;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;
  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  private String recordCode;
  /**
   * 商品的各个维度的信息
   */
  @ApiModelProperty("商品的各个维度的信息")
  private ProductDimensionDto productDimensionDto;
  /**
   * 物料的各个维度的信息
   */
  @ApiModelProperty("物料的各个维度的信息")
  private MaterialDimensionDto materialDimensionDto;
}
