package com.biz.crm.cps.business.agreement.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 分利协议模板分页查询dto
 *
 * @author jerry7
 * @date 2021-07-23
 */
@Data
@ApiModel
public class ProfitAgreementTemplatePaginationDto implements Serializable {
  private static final long serialVersionUID = 731039425767128160L;

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  private String templateCode;

  /**
   * 模板名称
   */
  @ApiModelProperty("模板名称")
  private String templateName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 包含组织组织编码列表
   */
  @ApiModelProperty("组织编码集合")
  private List<String> orgCodes;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 渠道编码
   */
  @ApiModelProperty("渠道编码")
  private String channelCode;

  /**
   * 包含政策名称
   */
  @ApiModelProperty("包含政策名称")
  private String policyName;

  /**
   * 包含政策编码
   */
  @ApiModelProperty("包含政策编码")
  private String policyCode;

  /**
   * 状态
   */
  @ApiModelProperty("状态")
  private String status;

  /**
   * 协议生效开始日期
   */
  @ApiModelProperty("协议生效开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date effectiveStartTime;

  /**
   * 协议生效结束日期
   */
  @ApiModelProperty("协议生效结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date effectiveEndTime;

  /**
   * 协议签署开始日期
   */
  @ApiModelProperty("协议签署开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signStartTime;

  /**
   * 协议签署结束日期
   */
  @ApiModelProperty("协议签署结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signEndTime;

  /**
   * 渠道名称
   */
  @ApiModelProperty("渠道名称")
  private String channelName;

  /**
   * 协议生效开始日期
   */
  @ApiModelProperty("协议生效范围开始日期(验重获取生效时间交集)")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date effectiveScopeStartTime;

  /**
   * 协议生效结束日期(验重获取生效时间交集)
   */
  @ApiModelProperty("协议生效范围结束日期(验重获取生效时间交集)")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date effectiveScopeEndTime;

  /**
   * 查询标记: H5/ADMIN
   */
  @ApiModelProperty("查询标记: H5/ADMIN")
  private String queryFlag;

  /**
   * 模板编码集合
   */
  @ApiModelProperty("模板编码集合")
  private List<String> templateCodes;

  /**
   * 权限类型
   */
  @ApiModelProperty("权限类型：0全部终端门店，1部分终端门店，2指定终端门店")
  private Integer permissionType;


  /**
   * 标签
   */
  @ApiModelProperty("标签")
  private Set<String> tags;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

}
