package com.biz.crm.cps.business.agreement.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author jerry7
 * @date 2021/8/5 14:58
 * 协议模板VO接口
 */
public interface AgreementTemplateVoService {

  /**
   * 分页条件查询协议模板
   * @param pageable 分页信息
   * @param profitAgreementTemplatePaginationDto 分页查询dto
   * @return 分页返回信息
   */
  Page<AgreementTemplateVo> findByConditions(Pageable pageable, ProfitAgreementTemplatePaginationDto profitAgreementTemplatePaginationDto);

  /**
   * 终端未签署展示的模板信息
   * @param pageable 分页信息
   * @param dto 分页查询dto
   * @return 分页返回信息
   */
  Page<AgreementTemplateVo> findListByConditions(Pageable pageable, ProfitAgreementTemplatePaginationDto dto);
  /**
   * 条件查询协议模板
   * @param profitAgreementTemplatePaginationDto 分页查询dto
   * @return 分页返回信息
   */
  List<AgreementTemplateVo> findByConditions(ProfitAgreementTemplatePaginationDto profitAgreementTemplatePaginationDto);
}
