package com.biz.crm.cps.business.agreement.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 协议实例voService
 * @author songjingen
 */
public interface AgreementVoService {

  /**
   * 根据登录信息查询出协议实例集合
   * @param dto
   * @return
   */
  List<AgreementVo> findByConditions(LoginUserAgreementDto dto);

  /**
   * 根据条件分页查询分利协议信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<AgreementVo> findByConditions(Pageable pageable, AgreementDto dto);

  /**
   * 查询协议信息，关联协议文本和终端签名
   * @param id
   * @return
   */
  AgreementVo findById(String id);

  /**
   * 根据协议编码查询协议信息
   * @param agreementCode
   * @return
   */
  AgreementVo findByAgreementCode(String agreementCode);

  /**
   * 查询当前用户的协议信息是否存在
   * @return
   */
  Boolean findExistByCurrentUser();
}
