package com.biz.crm.cps.business.agreement.sdk.service.observer;

/**
 * 协议政策挂载观察
 *   政策模块实现该接口，让协议模板模块知道系统中已经存在的政策实现
 * @Author: hefan
 */
public interface AgreementPolicyMountRegister {

  /**
   * 政策中文名称
   * 具体政策实现该方法，告知协议模板本政策的中文名（注意，具体的协议政策中，设定的该信息不能重复）
   * @return
   */
  String getName();

  /**
   * 政策key
   * 具体政策实现该方法，告知协议模板本政策的英文key（注意，具体的协议政策中，设定的该信息不能重复）
   * @return
   */
  String getKey();

  /**
   * 政策flag
   * 具体政策实现该方法，告知协议模板本政策的标识数字（注意，具体的协议政策中，设定的该信息不能重复）
   * @return
   */
  String getFlag();

}
