package com.biz.crm.cps.business.agreement.sdk.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;

/**
 * 协议政策观察----javabean转换
 *   政策模块实现该接口，用来处理协议模板与政策之间的对象转换
 * @Author: hefan
 */
public interface AgreementPolicyPojoObserver {

  /**
   * 反序列化：把json转为政策对象
   * @param jsonObject
   * @return
   */
  AgreementPolicyDto deserialize(JSONObject jsonObject);

  /**
   * 序列化: 把政策对象转为json
   * @param agreementPolicyDto
   * @return
   */
  JSONObject serialize(AgreementPolicyDto agreementPolicyDto);

}
