package com.biz.crm.cps.business.agreement.sdk.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.PolicyObserverDto;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.vo.PolicyRewardDataVo;

import java.util.List;
import java.util.Set;

/**
 * 协议政策观察----serviceAPI
 *   政策模块实现该接口，提供协议模板要求政策提供的API
 * @Author: hefan
 */
public interface AgreementPolicyServiceObserver {

  /**
   * 保存政策的配置信息
   * @param agreementPolicyDto
   */
  void onCreate(AgreementPolicyDto agreementPolicyDto);

  /**
   * 根据协议模板查询详细信息
   * @param templateCode
   * @return
   */
  AgreementPolicyVo onFindDetailsByTemplateCode(String templateCode);

  /**
   * 处理扫码动作，
   * 当政策需要对扫码行为做内部处理的时候，实现该接口
   *
   * 根据配置模板集合查询【政策配置】 --入参
   * 根据维度筛选【配置行】
   * 根据主体，码类型 筛选奖励条件 -- 入参
   * @param policyObserverDto
   */
  default void onProcessScanCode(PolicyObserverDto policyObserverDto){}

  /**
   * 保存政策的配置信息
   * 该json对象：{
   *   "@某个policyKey":{},
   *   "@另一个policyKey":{},
   * }
   * @param jsonObject
   */
  void onCreate(JSONObject jsonObject);

  /**
   * 查询政策的配置条件
   * @param templateCodeSet
   * @return
   */
  List<PolicyRewardDataVo> onFindPolicyRewardData(Set<String> templateCodeSet, String usertype);

  /**
   * 修改政策的配置信息
   * 该json对象：{
   *   "@某个policyKey":{},
   *   "@另一个policyKey":{},
   * }
   * @param jsonObject
   */
  void onChange(JSONObject jsonObject);
}
